/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999-2020 ohD(Twitter:@xm6_original)
 *	Copyright (C) 2001-2020 Ryu Takegami (Twitter:@RyuTakegami)
 *	Copyright (C) 2021 GIMONS (Twitter:@kugimoto0715)
 *	line printer support 2010-2013,2018 by Ben.JP
 *
 *	[ Win32API j[R}h ]
 *
 *	RHG
 *	  2001.08.01		V2ł̐VK2DDfBXNC[W쐬@\p~
 *	  2001.08.08		zbgZbg@\ǉ
 *	  2002.01.24		AWXg@\łVMbNp~
 *	  2002.03.03		Alt+F11̘Ałŗ邱ƂC
 *	  2002.05.04		F-BASIC[UfBXN쐬@\ǉ
 *						2D/VFDϊƐVKD77쐬̃_CAOƗ
 *	  2002.05.06		N[h؂芷FM-7[h̓ZbgȂ
 *						悤ɕύX
 *	  2002.05.07		_Z/ԃEBhEpǉ
 *	  2002.05.23		_Z/ԃEBhEɃ`FbNȂ
 *						C
 *	  2002.06.15		Xe[gt@C̓@񂪔fȂC
 *	  2002.07.10		TuEBhESĉB/@\ǉ
 *	  2002.09.13		tAZuEBhEPC񓯊[hɁuŐV̏
 *						ɍXVvIƕ\AhXςC
 *	  2002.10.21		g[X͋PCɂȂ悤ɕύX
 *	  2003.03.09		t@CIftHgfBNg̎ޕʕۑɑΉ
 *	  2004.05.03		tXN[ɎŃTuEBhEB悤ɕύX
 *						tXN[ɃTuEBhE֘Aj[𖳌
 *						悤ɕύX
 *	  2004.05.04		t@CI_CAȌʒuɃEBhE
 *						Ȃ悤ɕύX
 *	  2004.05.28		Xe[^Xo[̃foCXʃt@ChbvɑΉ
 *	  2004.10.05		fBXNC[W"&"܂܂Ăƃj[
 *						ɃvtBbNXƂďĂ܂C
 *		()
 *	  2012.12.04		V2/V3ɂBASIC/DOS[h̐؂ւ̍ۂ̃Zbg
 *						p~
 */

#ifdef _WIN32

#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <commdlg.h>
#include <shellapi.h>
#include <stdlib.h>
#include <assert.h>
#include <tchar.h>
#define DIRECTINPUT_VERSION		0x0300		/* DirectX3w */
#include <dinput.h>
#include <direct.h>
#include "xm7.h"
#include "fdc.h"
#include "tapelp.h"
#include "tools.h"
#include "mouse.h"
#include "rtc.h"
#include "display.h"
#include "subctrl.h"
#include "jsubsys.h"
#include "bubble.h"
#include "w32.h"
#include "w32_bar.h"
#include "w32_draw.h"
#include "w32_snd.h"
#include "w32_sch.h"
#include "w32_sub.h"
#include "w32_cfg.h"
#include "w32_res.h"
#include "w32_kbd.h"
#include "w32_comm.h"

/*
 *	O[o [N
 */
char InitialDir[INITIAL_DIRS][_MAX_DRIVE + _MAX_PATH];
BOOL bOFNCentering;
#ifdef KBDPASTE
HWND hKeyStrokeDialog;			/* L[͎x_CAOnh */
BOOL bKeyStrokeModeless;		/* L[͎x_CAO[hXtO */
#endif
char StatePath[_MAX_PATH];

/*
 *	X^eBbN [N
 */
static char DiskTitle[16 + 1];
static BOOL DiskMedia;
static BOOL DiskFormat;
#if XM7_VER == 1 && defined(BUBBLE)
static char BubbleTitle[16 + 1];
static BOOL BubbleFormat;
#endif
#ifdef KBDPASTE
static char KeyStrokeString[256];
static BOOL bImmStatus;
static DWORD dwConversion;
static DWORD dwSentence;
#endif
static WORD wMenuID = 0;

/*
 *	^錾
 */
typedef enum __MIDL___MIDL_itf_inputscope_0000_0001 {
	IS_DEFAULT	= 0,
	IS_HIRAGANA	= 44,
	IS_KATAKANA_HALFWIDTH	= 45,
	IS_KATAKANA_FULLWIDTH	= 46,
} InputScope;
typedef HRESULT (WINAPI *SETINPUTSCOPE)(HWND, InputScope);

/*
 *	vg^Cv錾
 */
extern int _getdrive(void);

/*
 *	ENTER/ESC/SPACE҂}N
 */
#define WAIT_KEY_POP()		while (	(GetAsyncKeyState(VK_RETURN) & 0x8000) || \
									(GetAsyncKeyState(VK_ESCAPE) & 0x8000) || \
									(GetAsyncKeyState(VK_SPACE) & 0x8000))

/*-[ ^Cg̓_CAO ]------------------------------------------------*/

/*
 *	^Cg̓_CAO
 *	_CAO
 */
static BOOL FASTCALL TitleDlgInit(HWND hDlg)
{
	HWND hWnd;
	RECT prect;
	RECT drect;

	ASSERT(hDlg);

	/* eEChE̒ɐݒ */
	hWnd = GetParent(hDlg);
	GetWindowRect(hWnd, &prect);
	GetWindowRect(hDlg, &drect);
	drect.right -= drect.left;
	drect.bottom -= drect.top;
	drect.left = (prect.right - prect.left) / 2 + prect.left;
	drect.left -= (drect.right / 2);
	drect.top = (prect.bottom - prect.top) / 2 + prect.top;
	drect.top -= (drect.bottom / 2);
	MoveWindow(hDlg, drect.left, drect.top, drect.right, drect.bottom, FALSE);

	/* GfBbgeLXg */
	hWnd = GetDlgItem(hDlg, IDC_TITLEEDIT);
	ASSERT(hWnd);
	strncpy(DiskTitle, "Default", sizeof(DiskTitle));
	SetWindowText(hWnd, DiskTitle);

#if XM7_VER >= 3
	/* fBA^Cv */
	CheckDlgButton(hDlg, IDC_TITLE2D, BST_CHECKED);
#endif

	return TRUE;
}

/*
 *	^Cg̓_CAO
 *	_CAOOK
 */
static void FASTCALL TitleDlgOK(HWND hDlg)
{
	HWND hWnd;
	char string[128];

	ASSERT(hDlg);

	/* GfBbgeLXg */
	hWnd = GetDlgItem(hDlg, IDC_TITLEEDIT);
	ASSERT(hWnd);

	/* 擾ARs[ */
	GetWindowText(hWnd, string, sizeof(string) - 1);
	memset(DiskTitle, 0, sizeof(DiskTitle));
	string[16] = '\0';
	strncpy(DiskTitle, string, sizeof(DiskTitle));

	/* fBA^Cv擾 */
#if XM7_VER >= 3
	if (IsDlgButtonChecked(hDlg, IDC_TITLE2DD)) {
		DiskMedia = TRUE;
	}
	else {
		DiskMedia = FALSE;
	}
#else
	/* V2ł2D̂ */
	DiskMedia = FALSE;
#endif

	if (IsDlgButtonChecked(hDlg, IDC_TITLEUSRDISK)) {
		DiskFormat = TRUE;
	}
	else {
		DiskFormat = FALSE;
	}
}

/*
 *	^Cg̓_CAO
 *	_CAOvV[W
 */
static BOOL CALLBACK TitleDlgProc(HWND hDlg, UINT iMsg,
									WPARAM wParam, LPARAM lParam)
{
	UNUSED(lParam);

	switch (iMsg) {
		/* _CAO */
		case WM_INITDIALOG:
			return TitleDlgInit(hDlg);

		/* R}h */
		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				/* OKELZ */
				case IDOK:
				case IDCANCEL:
					if (LOWORD(wParam) == IDOK) {
						TitleDlgOK(hDlg);
					}
					EndDialog(hDlg, LOWORD(wParam));
					InvalidateRect(hDrawWnd, NULL, FALSE);
					SetMenuExitTimer();
					return TRUE;
			}
			break;
	}

	/* ȊÓAFALSE */
	return FALSE;
}

/*-[ ^Cg̓_CAO(2D/VFDϊp) ]----------------------------------*/

/*
 *	^Cg̓_CAO(2D/VFDϊp)
 *	_CAO
 */
static BOOL FASTCALL TitleDlg2DInit(HWND hDlg)
{
	HWND hWnd;
	RECT prect;
	RECT drect;

	ASSERT(hDlg);

	/* eEChE̒ɐݒ */
	hWnd = GetParent(hDlg);
	GetWindowRect(hWnd, &prect);
	GetWindowRect(hDlg, &drect);
	drect.right -= drect.left;
	drect.bottom -= drect.top;
	drect.left = (prect.right - prect.left) / 2 + prect.left;
	drect.left -= (drect.right / 2);
	drect.top = (prect.bottom - prect.top) / 2 + prect.top;
	drect.top -= (drect.bottom / 2);
	MoveWindow(hDlg, drect.left, drect.top, drect.right, drect.bottom, FALSE);

	/* GfBbgeLXg */
	hWnd = GetDlgItem(hDlg, IDC_TITLEEDIT2D);
	ASSERT(hWnd);
	SetWindowText(hWnd, DiskTitle);

	return TRUE;
}

/*
 *	^Cg̓_CAO(2D/VFDϊp)
 *	_CAOOK
 */
static void FASTCALL TitleDlg2DOK(HWND hDlg)
{
	HWND hWnd;
	char string[128];

	ASSERT(hDlg);

	/* GfBbgeLXg */
	hWnd = GetDlgItem(hDlg, IDC_TITLEEDIT2D);
	ASSERT(hWnd);

	/* 擾ARs[ */
	GetWindowText(hWnd, string, sizeof(string) - 1);
	memset(DiskTitle, 0, sizeof(DiskTitle));
	string[16] = '\0';
	strncpy(DiskTitle, string, sizeof(DiskTitle));
}

/*
 *	^Cg̓_CAO(2D/VFDϊp)
 *	_CAOvV[W
 */
static BOOL CALLBACK TitleDlg2DProc(HWND hDlg, UINT iMsg,
									WPARAM wParam, LPARAM lParam)
{
	UNUSED(lParam);

	switch (iMsg) {
		/* _CAO */
		case WM_INITDIALOG:
			return TitleDlg2DInit(hDlg);

		/* R}h */
		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				/* OKELZ */
				case IDOK:
				case IDCANCEL:
					if (LOWORD(wParam) == IDOK) {
						TitleDlg2DOK(hDlg);
					}
					EndDialog(hDlg, LOWORD(wParam));
					InvalidateRect(hDrawWnd, NULL, FALSE);
					SetMenuExitTimer();
					return TRUE;
			}
			break;
	}

	/* ȊÓAFALSE */
	return FALSE;
}

/*-[ ouϊ^CvI_CAO ]----------------------------------------*/

#if XM7_VER == 1 && defined(BUBBLE)
/*
 *	ouϊ^CvI_CAO
 *	_CAO
 */
static BOOL FASTCALL BubbleMediaTypeDlgInit(HWND hDlg)
{
	HWND hWnd;
	RECT prect;
	RECT drect;

	ASSERT(hDlg);

	/* eEChE̒ɐݒ */
	hWnd = GetParent(hDlg);
	GetWindowRect(hWnd, &prect);
	GetWindowRect(hDlg, &drect);
	drect.right -= drect.left;
	drect.bottom -= drect.top;
	drect.left = (prect.right - prect.left) / 2 + prect.left;
	drect.left -= (drect.right / 2);
	drect.top = (prect.bottom - prect.top) / 2 + prect.top;
	drect.top -= (drect.bottom / 2);
	MoveWindow(hDlg, drect.left, drect.top, drect.right, drect.bottom, FALSE);

	/* GfBbgeLXg */
	hWnd = GetDlgItem(hDlg, IDC_TITLEEDIT);
	ASSERT(hWnd);
	SetWindowText(hWnd, BubbleTitle);

	/* tH[}bg^Cv */
	CheckDlgButton(hDlg, IDC_MEDIAFORMATB77, BST_CHECKED);

	return TRUE;
}

/*
 *	ouϊ^CvI_CAO
 *	_CAOOK
 */
static void FASTCALL BubbleMediaTypeDlgOK(HWND hDlg)
{
	ASSERT(hDlg);

	if (IsDlgButtonChecked(hDlg, IDC_MEDIAFORMATBBL)) {
		BubbleFormat = FALSE;
	}
	else {
		BubbleFormat = TRUE;
	}
}

/*
 *	ouϊ^CvI_CAO
 *	_CAOvV[W
 */
static BOOL CALLBACK BubbleMediaTypeDlgProc(HWND hDlg, UINT iMsg,
									WPARAM wParam, LPARAM lParam)
{
	UNUSED(lParam);

	switch (iMsg) {
		/* _CAO */
		case WM_INITDIALOG:
			return BubbleMediaTypeDlgInit(hDlg);

		/* R}h */
		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				/* OKELZ */
				case IDOK:
				case IDCANCEL:
					if (LOWORD(wParam) == IDOK) {
						BubbleMediaTypeDlgOK(hDlg);
					}
					EndDialog(hDlg, LOWORD(wParam));
					InvalidateRect(hDrawWnd, NULL, FALSE);
					SetMenuExitTimer();
					return TRUE;
				case IDC_MEDIAFORMATB77:
					EnableWindow(GetDlgItem(hDlg, IDC_TITLEEDIT), TRUE);
					return TRUE;
				case IDC_MEDIAFORMATBBL:
					EnableWindow(GetDlgItem(hDlg, IDC_TITLEEDIT), FALSE);
					return TRUE;
			}
			break;
	}

	/* ȊÓAFALSE */
	return FALSE;
}
#endif	/* XM7_VER == 1 */

/*-[ t@CIR_CAO ]-----------------------------------------*/

/*
 *	t@CIR_CAO
 *	
 */
static void FASTCALL FileDialogInit(HWND hDlg)
{
	RECT drect;
	RECT prect;
	HWND hWnd;

	/* _CAOCEChE̒Ɋ񂹂 */
	hWnd = GetParent(hDlg);
	GetWindowRect(hMainWnd, &prect);
	GetWindowRect(hWnd, &drect);
	drect.right -= drect.left;
	drect.bottom -= drect.top;
	drect.left = (prect.right - prect.left) / 2 + prect.left;
	drect.left -= (drect.right / 2);
	drect.top = (prect.bottom - prect.top) / 2 + prect.top;
	drect.top -= (drect.bottom / 2);
	MoveWindow(hWnd, drect.left, drect.top, drect.right, drect.bottom, FALSE);
}

/*
 *	t@CIR_CAO
 *	HOOK֐
 */
static UINT CALLBACK FileSelectHook(
						HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	UNUSED(wParam);
	UNUSED(lParam);

	switch (uMsg) {
		case WM_INITDIALOG:
			FileDialogInit(hDlg);
			return 0;
	}

	return 0;
}

/*
 *	t@CIR_CAO
 */
BOOL FASTCALL FileSelectSub(BOOL bOpen, UINT uFilterID, char *path, char *defext, BYTE IniDirNo)
{
	OPENFILENAME ofn;
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME + _MAX_EXT];
	char filter[4096];
	int i, j;
	SYSTEMTIME sysTime;

	ASSERT((bOpen == TRUE) || (bOpen == FALSE));
	ASSERT(uFilterID > 0);
	ASSERT(path);

	/* f[^쐬 */
	memset(&ofn, 0, sizeof(ofn));
	memset(path, 0, _MAX_PATH);
	memset(fname, 0, sizeof(fname));
	ofn.lStructSize = 76;	/* sizeof(ofn)V5g܂ */
	ofn.hwndOwner = hMainWnd;

	LoadString(hAppInstance, uFilterID, filter, sizeof(filter));
	j = strlen(filter);
	for (i=0; i<j; i++) {
		if (filter[i] == '|') {
			filter[i] = '\0';
		}
	}

	ofn.lpstrFilter = filter;
	ofn.lpstrFile = path;
	ofn.nMaxFile = _MAX_PATH;
	ofn.lpstrFileTitle = fname;
	ofn.nMaxFileTitle = sizeof(fname);
	ofn.lpstrDefExt = defext;
	ofn.lpstrInitialDir = InitialDir[IniDirNo];
	ofn.lpfnHook = FileSelectHook;

	/* R_CAOs */
	if (bOpen) {
		ofn.Flags = OFN_EXPLORER | OFN_HIDEREADONLY |
					OFN_FILEMUSTEXIST;
		if (bOFNCentering) {
			ofn.Flags |= OFN_ENABLEHOOK;
		}
		if (!GetOpenFileName(&ofn)) {
			SetMenuExitTimer();
			return FALSE;
		}
	}
	else {
		// t@C
		if (defext) {
			GetLocalTime(&sysTime);
			sprintf(path,
				_T("%04d%02d%02d%02d%02d%02d%04d."),
				sysTime.wYear,
				sysTime.wMonth,
				sysTime.wDay,
				sysTime.wHour,
				sysTime.wMinute,
				sysTime.wSecond,
				sysTime.wMilliseconds
				);
			strcat(path, defext);
		}

		SetSaveDialog(TRUE);
		ofn.Flags = OFN_EXPLORER | OFN_HIDEREADONLY |
					OFN_OVERWRITEPROMPT;
		if (bOFNCentering) {
			ofn.Flags |= OFN_ENABLEHOOK;
		}
		if (!GetSaveFileName(&ofn)) {
			SetSaveDialog(FALSE);
			SetMenuExitTimer();
			return FALSE;
		}
		SetSaveDialog(FALSE);
	}

	/* fBNgۑ */
	_splitpath(path, InitialDir[IniDirNo], dir, NULL, NULL);
	if (dir[strlen(dir)-1] == '\\') {
		/* Ō̃pX؂L͋Iɍ */
		dir[strlen(dir)-1] = '\0';
	}
	strncat(InitialDir[IniDirNo], dir,
			sizeof(InitialDir[IniDirNo]) - strlen(InitialDir[IniDirNo]) - 1);

	SetMenuExitTimer();
	return TRUE;
}

/*-[ L[͎x_CAO ]-----------------------------------------------*/

#ifdef KBDPASTE
/*
 *	L[͎x_CAO
 *	InputScopeύX
 */
static void FASTCALL SetInputScope(HWND hEdit, InputScope dwInputScope)
{
	char path[_MAX_PATH];
	HMODULE hMSCTF;
	SETINPUTSCOPE pfnSetInputScope;

	GetSystemDirectory(path, sizeof(path));
	strncat(path, "\\msctf.dll", sizeof(path) - strlen(path) - 1);
	hMSCTF = LoadLibrary(path);
	pfnSetInputScope = (SETINPUTSCOPE)GetProcAddress(hMSCTF, "SetInputScope");

	if (pfnSetInputScope) {
	(*pfnSetInputScope)(hEdit, dwInputScope);
	}

	FreeLibrary(hMSCTF);
}

/*
 *	L[͎x_CAO
 *	_CAO
 */
static BOOL FASTCALL KeyStrokeDlgInit(HWND hDlg)
{
	HWND hWnd;
	RECT prect;
	RECT drect;

	ASSERT(hDlg);

	/* eEChE̒ɐݒ */
	hWnd = GetParent(hDlg);
	GetWindowRect(hWnd, &prect);
	GetWindowRect(hDlg, &drect);
	drect.right -= drect.left;
	drect.bottom -= drect.top;
	drect.left = (prect.right - prect.left) / 2 + prect.left;
	drect.left -= (drect.right / 2);
	drect.top = (prect.bottom - prect.top) / 2 + prect.top;
	drect.top -= (drect.bottom / 2);
	MoveWindow(hDlg, drect.left, drect.top, drect.right, drect.bottom, FALSE);

	/*  */
	memset(KeyStrokeString, 0, sizeof(KeyStrokeString));

	return TRUE;
}

/*
 *	L[͎x_CAO
 *	_CAOOK
 */
static void FASTCALL KeyStrokeDlgOK(HWND hDlg)
{
	HWND hWnd;

	ASSERT(hDlg);

	/* GfBbgeLXg */
	hWnd = GetDlgItem(hDlg, IDC_KEYSTROKEEDIT);
	ASSERT(hWnd);

	/* 擾ARs[ */
	GetWindowText(hWnd, (LPTSTR)KeyStrokeString, sizeof(KeyStrokeString) - 1);
	SetWindowText(hWnd, (LPTSTR)"");
}

/*
 *	L[͎x_CAO
 *	_CAOvV[W
 */
static BOOL CALLBACK KeyStrokeDlgProc(HWND hDlg, UINT iMsg,
									WPARAM wParam, LPARAM lParam)
{
	HWND hWnd;
	HIMC hImm;

	UNUSED(lParam);

	switch (iMsg) {
		/* _CAO */
		case WM_INITDIALOG:
			/* GfBbgeLXg */
			hWnd = GetDlgItem(hDlg, IDC_KEYSTROKEEDIT);
			ASSERT(hWnd);

			/* IMMݒ𔼊pJiɐݒ */
			SetFocus(hWnd);					/* WIn8/Win10 ATOKp */
			if (bWin8flag) {
				SetInputScope(hWnd, IS_KATAKANA_HALFWIDTH);
			}
			hImm = ImmGetContext(hWnd);
			bImmStatus = ImmGetOpenStatus(hImm);
			ImmGetConversionStatus(hImm, &dwConversion, &dwSentence);
			ImmSetOpenStatus(hImm, TRUE);
			ImmSetConversionStatus(hImm,
					IME_CMODE_NATIVE | IME_CMODE_KATAKANA |
					IME_CMODE_ROMAN, IME_SMODE_NONE);
			ImmReleaseContext(hWnd, hImm);		/* gp͉ */

			return KeyStrokeDlgInit(hDlg);

		/* R}h */
		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				/* OKELZ */
				case IDOK:
				case IDCANCEL:
					WAIT_KEY_POP();
					if (LOWORD(wParam) == IDOK) {
						KeyStrokeDlgOK(hDlg);
						if (strlen(KeyStrokeString) == 0) {
							break;
						}
						if (hKeyStrokeDialog) {
							/* 쐬 */
							LockVM();
							PasteKbd((char *)KeyStrokeString);
							UnlockVM();
							SetForegroundWindow(hMainWnd);
							break;
						}
					}

					/* GfBbgeLXg */
					hWnd = GetDlgItem(hDlg, IDC_KEYSTROKEEDIT);
					ASSERT(hWnd);

					/* IMMݒ̕A */
					SetFocus(hWnd);					/* WIn8/Win10 ATOKp */
					if (bWin8flag) {
						SetInputScope(hWnd, IS_DEFAULT);
					}
					hImm = ImmGetContext(hWnd);
					ImmSetOpenStatus(hImm, bImmStatus);
					ImmSetConversionStatus(hImm, dwConversion, dwSentence);
					ImmReleaseContext(hWnd, hImm);

					if (hKeyStrokeDialog) {
						DestroyWindow(hKeyStrokeDialog);
						hKeyStrokeDialog = NULL;
					}
					else {
						EndDialog(hDlg, LOWORD(wParam));
					}

					InvalidateRect(hDrawWnd, NULL, FALSE);
					SetMenuExitTimer();
					return TRUE;
			}
			break;
	}

	/* ȊÓAFALSE */
	return FALSE;
}
#endif

/*-[ ėpTu ]-------------------------------------------------------------*/

/*
 *	j[Enable
 */
void FASTCALL EnableMenuSub(HMENU hMenu, UINT uID, BOOL bEnable)
{
	ASSERT(hMenu);
	ASSERT(uID > 0);

	if (bEnable) {
		EnableMenuItem(hMenu, uID, MF_BYCOMMAND | MF_ENABLED);
	}
	else {
		EnableMenuItem(hMenu, uID, MF_BYCOMMAND | MF_GRAYED);
	}
}

/*
 *	j[Enable (ʒuw)
 */
#if XM7_VER == 1 && defined(BUBBLE)
void FASTCALL EnableMenuPos(HMENU hMenu, UINT uPos, BOOL bEnable)
{
	ASSERT(hMenu);
	ASSERT(uPos > 0);

	if (bEnable) {
		EnableMenuItem(hMenu, uPos, MF_BYPOSITION | MF_ENABLED);
	}
	else {
		EnableMenuItem(hMenu, uPos, MF_BYPOSITION | MF_GRAYED);
	}
}
#endif

/*
 *	j[Check
 */
void FASTCALL CheckMenuSub(HMENU hMenu, UINT uID, BOOL bCheck)
{
	ASSERT(hMenu);
	ASSERT(uID > 0);

	if (bCheck) {
		CheckMenuItem(hMenu, uID, MF_BYCOMMAND | MF_CHECKED);
	}
	else {
		CheckMenuItem(hMenu, uID, MF_BYCOMMAND | MF_UNCHECKED);
	}
}

/*-[ t@Cj[ ]-----------------------------------------------------*/

/*
 *	Xe[g[h
 */
static void FASTCALL StateLoad(char *path)
{
	char string[256];
	int state;

	state = system_load(path);
	if (state == STATELOAD_ERROR) {
		/* {̓ǂݍݒ̃G[̂݃Zbg */
		system_reset();
		SetAllMRUFile();
		OnRefresh(hMainWnd);
	}
	if (state != STATELOAD_SUCCESS) {
		LoadString(hAppInstance, IDS_STATEERROR, string, sizeof(string));
		MessageBox(hMainWnd, string, "XM7", MB_ICONSTOP | MB_OK);
		SetMenuExitTimer();
	}
	else {
		strncpy(StatePath, path, sizeof(StatePath));
		SetAllMRUFile();
		OnRefresh(hMainWnd);
	}

	/* Esǂ̃P[Xł^[Qbg@ύX */
	GetCfg();
	SetMachineVersion();
}

/*
 *	t@CtbZ[W{bNX
 */
static int FASTCALL FileMessageBox(HWND hWnd, UINT uID, char *path, UINT uType)
{
	char string[256];
	char buffer[256];
	char tmp[256];
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];

	memset(&tmp, 0, sizeof(tmp));
	if (path != NULL) {
		if (path[0] != '\0') {
			_splitpath(path, drive, dir, fname, ext);
			if (strlen(dir) > 1) {
				strncpy(dir, "\\...\\", sizeof(dir));
			}
			strncpy(tmp, drive, sizeof(tmp));
			strncat(tmp, dir, sizeof(tmp)-strlen(tmp)-1);
			strncat(tmp, fname, sizeof(tmp)-strlen(tmp)-1);
			strncat(tmp, ext, sizeof(tmp)-strlen(tmp)-1);
		}
	}

	LoadString(hAppInstance, uID, buffer, sizeof(buffer));
	_snprintf(string, sizeof(string), buffer, tmp);
	return MessageBox(hWnd, string, "XM7", uType);
}

/*
 *	t@CXV
 */
static UINT FASTCALL AppendMenuHistory(HMENU hMenu, UINT uItem, UINT uID, int type, BOOL enable)
{
	MENUITEMINFO mii;
	char string[256+1];
	char buffer[512+1];	/* ň̃P[Xz(蓾Ȃ) */
	int	i, j, k;

	ASSERT(hMenu);

	/* j[\̏ */
	memset(&mii, 0, sizeof(mii));
	mii.cbSize = 44;	/* sizeof(mii)WINVER>=0x0500 */
	mii.fMask = MIIM_TYPE | MIIM_STATE | MIIM_ID;
	mii.fType = MFT_STRING;
	if (enable) {
		mii.fState = MFS_ENABLED;
	}
	else {
		mii.fState = MFS_GRAYED;
	}

	/*  */
	if (GetMRUNum(type) != 0) {
		/* Zp[^} */
		mii.fType = MFT_SEPARATOR;
		InsertMenuItem(hMenu, uItem++, TRUE, &mii);
		mii.fType = MFT_STRING;

		/*  */
		for (i=0; i<MRU_FILES; i++) {
			/* 擾Ă݂ */
			GetMRUFile(type, i, buffer, sizeof(buffer));
			if (buffer[0] == '\0') {
				break;
			}

			/* ΃j[ɒǉ */
			mii.wID = uID + i;

			/* vtBbNX΍ */
			_snprintf(string, sizeof(string), "&%d ", i + 1);
			k = strlen(string);
			for (j = 0; j < (int)strlen(buffer); j++) {
				if (buffer[j] == '&') {
					string[k++] = '&';
				}
				string[k++] = buffer[j];
			}
			string[k] = '\0';
			mii.dwTypeData = string;
			mii.cch = strlen(string);
			InsertMenuItem(hMenu, uItem++, TRUE, &mii);
		}
	}

	return uItem;
}

/*
 *	ReLXgj[o͏
 */
static void FASTCALL OnContextualSubMenu(HWND hWnd, HMENU hMenu, WORD wID, int x, int y)
{
	POINT point;
	HMENU hSubMenu;
	WORD wRet;
	
	/* Tuj[\\[XIDۑ */
	wMenuID = wID;

	/* ReLXgj[s */
	point.x = x;
	point.y = y;
	hSubMenu = GetSubMenu(hMenu, 0);
	wRet = (WORD)TrackPopupMenu(hSubMenu, TPM_RECURSE|TPM_RETURNCMD, point.x, point.y, 0, hWnd, NULL);
	if (wRet != 0) {
		EnterMenu(hWnd, FALSE);
		OnCommand(hWnd, wRet);
		ExitMenu(FALSE);
		OnExitMenuLoop();
		SetMenuExitTimer();
		bMenuLoop = FALSE;
	}
}

/*
 *	qXg폜
 */
static void FASTCALL DeleteHistory(HWND hWnd, WORD wID)
{
	char string[256 + 1];
	int type;
	int index;
	int nret;

	/* XgZbg */
	if ((wID >= IDM_STATE_FILE0) && (wID <= IDM_STATE_FILE9)) {
		type = MRU_STATE;
		index = wID - IDM_STATE_FILE0;
	}
	if ((wID >= IDM_D1_FILE0) && (wID <= IDM_D1_FILE9)) {
		type = MRU_MFD1;
		index = wID - IDM_D1_FILE0;
	}
	if ((wID >= IDM_D0_FILE0) && (wID <= IDM_D0_FILE9)) {
		type = MRU_MFD0;
		index = wID - IDM_D0_FILE0;
	}
	if ((wID >= IDM_T_FILE0) && (wID <= IDM_T_FILE9)) {
		type = MRU_TAPE;
		index = wID - IDM_T_FILE0;
	}
#if XM7_VER == 1 && defined(BUBBLE)
	if ((wID >= IDM_B1_FILE0) && (wID <= IDM_B1_FILE9)) {
		type = MRU_BBL1;
		index = wID - IDM_B1_FILE0;
	}
	if ((wID >= IDM_B0_FILE0) && (wID <= IDM_B0_FILE9)) {
		type = MRU_BBL0;
		index = wID - IDM_B0_FILE0;
	}
#endif

	/* 擾Ă݂ */
	GetMRUFile(type, index, string, sizeof(string));
	nret = FileMessageBox(hWnd, IDS_HISTORY_DELETE, string, MB_ICONQUESTION | MB_YESNO);

	/* mFʂɂ */
	switch (nret) {
		/* YES */
		case IDYES:
			/* Xe[gZ[u */
			LockVM();
			StopSnd();
			DelMRUFile(type, index);
			PlaySnd();
			UnlockVM();
			break;

		/* NO */
		case IDNO:
			break;
	}
}

/*-[ t@Cj[ ]-----------------------------------------------------*/

/*
 *	J(O)
 */
static void FASTCALL OnOpen(HWND hWnd)
{
	char path[_MAX_PATH];

	ASSERT(hWnd);

	/* t@CITu */
	if (!FileSelectSub(TRUE, IDS_STATEFILTER, path, NULL, STATE_FILE_DIR)) {
		return;
	}

	/* Xe[g[h */
	LockVM();
	StopSnd();
	StateLoad(path);
	PlaySnd();
	ResetSch();
	UnlockVM();

	/* ʍĕ` */
	OnRefresh(hWnd);
}

/*
 *	Otĕۑ(A)
 */
static void FASTCALL OnSaveAs(HWND hWnd)
{
	char path[_MAX_PATH];

	ASSERT(hWnd);

	/* t@CITu */
	if (!FileSelectSub(FALSE, IDS_STATEFILTER, path, "XM7", STATE_FILE_DIR)) {
		return;
	}

	/* Xe[gZ[u */
	LockVM();
	StopSnd();
	if (!system_save(path)) {
		LoadString(hAppInstance, IDS_STATEERROR, path, sizeof(path));
		MessageBox(hWnd, path, "XM7", MB_ICONSTOP | MB_OK);
		SetMenuExitTimer();
	}
	else {
		strncpy(StatePath, path, sizeof(StatePath));
		SetMRUFile(MRU_STATE, StatePath);
	}
	PlaySnd();
	ResetSch();
	UnlockVM();
}

/*
 *	㏑ۑ(S)
 */
static void FASTCALL OnSave(HWND hWnd)
{
	char string[128];

	/* ܂ۑĂȂ΁AO */
	if (StatePath[0] == '\0') {
		OnSaveAs(hWnd);
		return;
	}

	/* Xe[gZ[u */
	LockVM();
	StopSnd();
	if (!system_save(StatePath)) {
		LoadString(hAppInstance, IDS_STATEERROR, string, sizeof(string));
		MessageBox(hWnd, string, "XM7", MB_ICONSTOP | MB_OK);
		SetMenuExitTimer();
	}
	else {
		SetMRUFile(MRU_STATE, StatePath);
	}
	PlaySnd();
	ResetSch();
	UnlockVM();
}

#ifdef LPRINT
/*
 *	(P)
 */
static void FASTCALL OnPrint(void)
{
	lp_print();
}
#endif

/*
 *	Zbg(R)
 */
static void FASTCALL OnReset(HWND hWnd)
{
	LockVM();
	system_reset();
	StatePath[0] = '\0';
	SetAllMRUFile();
	ResetSch();
	UnlockVM();

	/* ĕ` */
	OnRefresh(hWnd);
}

/*
 *	zbgZbg(H)
 */
static void FASTCALL OnHotReset(HWND hWnd)
{
	LockVM();
	system_hotreset();
	UnlockVM();

	/* ĕ` */
	OnRefresh(hWnd);
}

/*
 *	TAB+Zbg(F)
 */
#if XM7_VER >= 3
static void FASTCALL OnTabReset(HWND hWnd)
{
	if (!init_is_exsx || (fm7_ver <= 2)) {
		return;
	}

	LockVM();
	system_tabreset();
	UnlockVM();

	/* ĕ` */
	OnRefresh(hWnd);
}
#endif

/*
 *	BASIC[h(B)
 */
static void FASTCALL OnBasic(void)
{
	LockVM();
	boot_mode = BOOT_BASIC;
	GetCfg();
#if XM7_VER >= 2
	if (fm7_ver < 2) {
		mainmem_transfer_boot();
	}
#else
	if (fm_subtype == FMSUB_FM8) {
		basicrom_en = TRUE;
	}
#endif
	UnlockVM();
}

/*
 *	DOS[h(D)
 */
static void FASTCALL OnDos(void)
{
	LockVM();
	boot_mode = BOOT_DOS;
	GetCfg();
#if XM7_VER >= 2
	if (fm7_ver < 2) {
		mainmem_transfer_boot();
	}
#else
	if (fm_subtype == FMSUB_FM8) {
		basicrom_en = FALSE;
	}
#endif
	UnlockVM();
}

/*
 *	ou[h(U)
 */
#if XM7_VER == 1 && defined(BUBBLE)
static void FASTCALL OnBubble(void)
{
	LockVM();
	boot_mode = BOOT_BUBBLE;
	GetCfg();
	if (fm_subtype == FMSUB_FM8) {
		basicrom_en = FALSE;
	}
	UnlockVM();
}
#endif

/*
 *	I(X)
 */
static void FASTCALL OnExit(HWND hWnd)
{
	/* EChEN[Y */
	PostMessage(hWnd, WM_CLOSE, 0, 0);
}

/*
 *	t@C(F)j[
 */
static BOOL OnFile(HWND hWnd, WORD wID)
{
	ASSERT(hWnd);

	switch (wID) {
		/* I[v */
		case IDM_OPEN:
			OnOpen(hWnd);
			return TRUE;

		/* ㏑ۑ */
		case IDM_SAVE:
			OnSave(hWnd);
			return TRUE;

		/* Oĕۑ */
		case IDM_SAVEAS:
			OnSaveAs(hWnd);
			return TRUE;

#ifdef LPRINT
		/*  */
		case IDM_PRINT:
			OnPrint();
			return TRUE;
#endif

		/* Zbg */
		case IDM_RESET:
			OnReset(hWnd);
			return TRUE;

		/* zbgZbg */
		case IDM_HOTRESET:
			OnHotReset(hWnd);
			return TRUE;

#if XM7_VER >= 3
		/* TAB+Zbg */
		case IDM_TABRESET:
			OnTabReset(hWnd);
			return TRUE;
#endif

		/* BASIC[h */
		case IDM_BASIC:
			OnBasic();
			return TRUE;

		/* DOS[h */
		case IDM_DOS:
			OnDos();
			return TRUE;

#if XM7_VER == 1 && defined(BUBBLE)
		/* ou[h */
		case IDM_BUBBLE:
			OnBubble();
			return TRUE;
#endif

		/* I */
		case IDM_EXIT:
			OnExit(hWnd);
			return TRUE;
	}

	if ((wID >= IDM_STATE_FILE0) && (wID <= IDM_STATE_FILE9)) {
		char string[256 + 1];
		GetMRUFile(MRU_STATE, wID - IDM_STATE_FILE0, string, sizeof(string));

		LockVM();
		StopSnd();
		StateLoad(string);
		PlaySnd();
		ResetSch();
		UnlockVM();

		/* ʍĕ` */
		OnRefresh(hWnd);

		/* \eXV */
		OnSize(hWnd, 640, 400);

		return TRUE;
	}

	return FALSE;
}

/*
 *	t@C(F)j[XV
 */
static void FASTCALL OnFilePopup(HMENU hMenu)
{
	MENUITEMINFO mii;
	char string[128];
	UINT uItem;
	UINT id;

	ASSERT(hMenu);

	/* j[\̏ */
	memset(&mii, 0, sizeof(mii));
	mii.cbSize = 44;	/* sizeof(mii)WINVER>=0x0500 */
	mii.fMask = MIIM_TYPE | MIIM_STATE | MIIM_ID;
	mii.fType = MFT_STRING;
	mii.fState = MFS_ENABLED;
	uItem = 9;
#if XM7_VER == 1 && defined(BUBBLE)
	uItem += 1;		/* ou[hI */
#elif XM7_VER >= 3
	uItem += 1;		/* TAB+Zbg */
#endif
#ifdef LPRINT
	uItem += 2;		/* @\ */
#endif

	/* Zp[^āAȍ~̃j[ׂ͂č폜 */
	while (GetMenuItemCount(hMenu) > (int)uItem) {
		DeleteMenu(hMenu, uItem, MF_BYPOSITION);
	}

	/* } */
	uItem = AppendMenuHistory(hMenu, uItem, IDM_STATE_FILE0, MRU_STATE, TRUE);

	/* Zp[^} */
	mii.fType = MFT_SEPARATOR;
	InsertMenuItem(hMenu, uItem++, TRUE, &mii);
	mii.fType = MFT_STRING;

	/* Ij[ǉ */
	mii.fMask = MIIM_TYPE | MIIM_STATE | MIIM_ID;
	mii.wID = IDM_EXIT;
	LoadString(hAppInstance, IDS_EXIT, string, sizeof(string));
	mii.dwTypeData = string;
	mii.cch = strlen(string);
	InsertMenuItem(hMenu, uItem++, TRUE, &mii);

	switch (boot_mode) {
		case BOOT_BASIC:
			id = IDM_BASIC;
			break;
		case BOOT_DOS:
			id = IDM_DOS;
			break;
#if XM7_VER == 1 && defined(BUBBLE)
		case BOOT_BUBBLE:
			id = IDM_BUBBLE;
			break;
#endif
		default:
			ASSERT(FALSE);
			break;
	}

#if XM7_VER == 1 && defined(BUBBLE)
	CheckMenuRadioItem(hMenu, IDM_BASIC, IDM_BUBBLE, id, MF_BYCOMMAND);
	EnableMenuSub(hMenu, IDM_BUBBLE, (fm_subtype == FMSUB_FM8) && bubble_available);
#else
	CheckMenuRadioItem(hMenu, IDM_BASIC, IDM_DOS, id, MF_BYCOMMAND);
#endif

#if XM7_VER >= 3
	EnableMenuSub(hMenu, IDM_TABRESET, (fm7_ver >= 3) && init_is_exsx);
#endif

#ifdef LPRINT
	EnableMenuSub(hMenu, IDM_PRINT, (lp_use == LP_EMULATION));
#endif
}

/*
 *	t@C(F)ReLXgj[
 */
static BOOL FASTCALL OnFileContextualMenu(HWND hWnd, WORD wID, int x, int y)
{
	ASSERT(hWnd);

	/* qXg */
	if ((wID >= IDM_STATE_FILE0) && (wID <= IDM_STATE_FILE9)) {
		OnContextualSubMenu(hWnd, hHistoryMenu, wID, x, y);
		return TRUE;
	}

	return FALSE;
}

/*-[ fBXNj[ ]-----------------------------------------------------*/

/*
 *	hCuJ
 */
static void FASTCALL OnDiskOpen(int Drive)
{
	char path[_MAX_PATH];

	ASSERT((Drive == 0) || (Drive == 1));

	/* t@CI */
	if (!FileSelectSub(TRUE, IDS_DISKFILTER, path, NULL, DISK_IMAGE_DIR)) {
		return;
	}

	/* Zbg */
	LockVM();
	fdc_setdisk(Drive, path);
	if (fdc_ready[Drive] != FDC_TYPE_NOTREADY) {
		SetMRUFile(MRU_MFD0 + Drive, fdc_fname[Drive]);
	}
	ResetSch();
	UnlockVM();
}

/*
 *	hCuJ
 */
static void FASTCALL OnDiskBoth(void)
{
	char path[_MAX_PATH];

	/* t@CI */
	if (!FileSelectSub(TRUE, IDS_DISKFILTER, path, NULL, DISK_IMAGE_DIR)) {
		return;
	}

	/* Zbg */
	LockVM();
	fdc_setdisk(0, path);
	fdc_setdisk(1, NULL);
	if (fdc_ready[0] != FDC_TYPE_NOTREADY) {
		SetMRUFile(MRU_MFD0, fdc_fname[0]);
	}
	if ((fdc_ready[0] != FDC_TYPE_NOTREADY) && (fdc_medias[0] >= 2)) {
		fdc_setdisk(1, path);
		fdc_setmedia(1, 1);
		if (fdc_ready[1] != FDC_TYPE_NOTREADY) {
			SetMRUFile(MRU_MFD1, fdc_fname[1]);
			SetMRUMedia(MRU_MFD1, fdc_media[1]);
		}
	}
	ResetSch();
	UnlockVM();
}

/*
 *	fBXNCWFNg
 */
static void FASTCALL OnDiskEject(int Drive)
{
	ASSERT((Drive == 0) || (Drive == 1));

	/* CWFNg */
	LockVM();
	fdc_setdisk(Drive, NULL);
	UnlockVM();
}

/*
 *	fBXNꎞo
 */
static void FASTCALL OnDiskTemp(int Drive)
{
	ASSERT((Drive == 0) || (Drive == 1));

	/* ݋֎~؂ւ */
	LockVM();
	if (fdc_teject[Drive]) {
		fdc_teject[Drive] = FALSE;
	}
	else {
		fdc_teject[Drive] = TRUE;
	}
	UnlockVM();
}

/*
 *	fBXN݋֎~
 */
static void FASTCALL OnDiskProtect(int Drive)
{
	ASSERT((Drive == 0) || (Drive == 1));

	/* ݋֎~؂ւ */
	LockVM();
	if (fdc_writep[Drive]) {
		fdc_setwritep(Drive, FALSE);
	}
	else {
		fdc_setwritep(Drive, TRUE);
	}
	ResetSch();
	UnlockVM();
}

/*
 *	fBXN(1)(0)j[
 */
static BOOL FASTCALL OnDisk(WORD wID)
{
	switch (wID) {
		/* J */
		case IDM_D0OPEN:
			OnDiskOpen(0);
			break;
		case IDM_D1OPEN:
			OnDiskOpen(1);
			break;

		/* hCuŊJ */
		case IDM_DBOPEN:
			OnDiskBoth();
			break;

		/* O */
		case IDM_D0EJECT:
			OnDiskEject(0);
			break;
		case IDM_D1EJECT:
			OnDiskEject(1);
			break;

		/* ꎞCWFNg */
		case IDM_D0TEMP:
			OnDiskTemp(0);
			break;
		case IDM_D1TEMP:
			OnDiskTemp(1);
			break;

		/* ݋֎~ */
		case IDM_D0WRITE:
			OnDiskProtect(0);
			break;
		case IDM_D1WRITE:
			OnDiskProtect(1);
			break;
	}

	/* fBA */
	if ((wID >= IDM_D0MEDIA00) && (wID <= IDM_D0MEDIA15)) {
		LockVM();
		fdc_setmedia(0, wID - IDM_D0MEDIA00);
		SetMRUMedia(MRU_MFD0, fdc_media[0]);
		ResetSch();
		UnlockVM();
	}
	if ((wID >= IDM_D1MEDIA00) && (wID <= IDM_D1MEDIA15)) {
		LockVM();
		fdc_setmedia(1, wID - IDM_D1MEDIA00);
		SetMRUMedia(MRU_MFD1, fdc_media[1]);
		ResetSch();
		UnlockVM();
	}

	/* XgZbg */
	if ((wID >= IDM_D1_FILE0) && (wID <= IDM_D0_FILE9)) {
		char path[256 + 1];
		int drive;
		int mrutype;
		int index;
		int media;

		if ((wID >= IDM_D0_FILE0) && (wID <= IDM_D0_FILE9)) {
			drive	= 0;
			mrutype	= MRU_MFD0;
			index	= wID - IDM_D0_FILE0;
		}
		if ((wID >= IDM_D1_FILE0) && (wID <= IDM_D1_FILE9)) {
			drive	= 1;
			mrutype	= MRU_MFD1;
			index	= wID - IDM_D1_FILE0;
		}
		GetMRUFile(mrutype, index, path, sizeof(path));
		media = GetMRUMedia(mrutype, index);

		LockVM();
		fdc_setdisk(drive, path);
		if (fdc_ready[drive] != FDC_TYPE_NOTREADY) {
			SetMRUFile(mrutype, fdc_fname[drive]);
			if (fdc_ready[drive] == FDC_TYPE_D77) {
				if (media >= 0) {
					fdc_setmedia(drive, media);
				}
				SetMRUMedia(mrutype, fdc_media[drive]);
			}
		}
		else {
			FileMessageBox(hMainWnd, IDS_FILE_NOT_FOUND, path, MB_ICONSTOP | MB_OK);
			SetMenuExitTimer();
		}
		ResetSch();
		UnlockVM();
	}

	return FALSE;
}

/*
 *	fBXN(1)(0)j[XV
 */
static void FASTCALL OnDiskPopup(HMENU hMenu, int Drive)
{
	MENUITEMINFO mii;
	char string[128];
	char buffer[128];
	int offset;
	int i;
	int j;
	int k;
	UINT uItem;

	ASSERT(hMenu);
	ASSERT((Drive == 0) || (Drive == 1));

	/* j[ׂč폜 */
	while (GetMenuItemCount(hMenu) > 0) {
		DeleteMenu(hMenu, 0, MF_BYPOSITION);
	}

	/* ItZbgm */
	if (Drive == 0) {
		offset = 0;
	}
	else {
		offset = IDM_D1OPEN - IDM_D0OPEN;
	}

	/* j[\̏ */
	memset(&mii, 0, sizeof(mii));
	mii.cbSize = 44;	/* sizeof(mii)WINVER>=0x0500 */
	mii.fMask = MIIM_TYPE | MIIM_STATE | MIIM_ID;
	mii.fType = MFT_STRING;
	mii.fState = MFS_ENABLED;

	/* I[vƁAI[v */
	mii.wID = IDM_D0OPEN + offset;
	LoadString(hAppInstance, IDS_DISKOPEN, string, sizeof(string));
	mii.dwTypeData = string;
	mii.cch = strlen(string);
	InsertMenuItem(hMenu, 0, TRUE, &mii);
	mii.wID = IDM_DBOPEN;
	LoadString(hAppInstance, IDS_DISKBOTH, string, sizeof(string));
	mii.cch = strlen(string);
	InsertMenuItem(hMenu, 1, TRUE, &mii);

	/* fBXN}ĂȂ΁A܂ */
	if (fdc_ready[Drive] == FDC_TYPE_NOTREADY) {
		/* } */
		AppendMenuHistory(hMenu, 2, IDM_D0_FILE0 - Drive * 10, 
			MRU_MFD0 + Drive, TRUE);
		return;
	}

	/* CWFNg */
	mii.wID = IDM_D0EJECT + offset;
	LoadString(hAppInstance, IDS_DISKEJECT, string, sizeof(string));
	mii.cch = strlen(string);
	InsertMenuItem(hMenu, 2, TRUE, &mii);

	/* Zp[^} */
	mii.fType = MFT_SEPARATOR;
	InsertMenuItem(hMenu, 3, TRUE, &mii);

	/* ꎞo */
	mii.wID = IDM_D0TEMP + offset;
	LoadString(hAppInstance, IDS_DISKTEMP, string, sizeof(string));
	if (fdc_teject[Drive]) {
		mii.fState = MFS_CHECKED | MFS_ENABLED;
	}
	else {
		mii.fState = MFS_ENABLED;
	}
	mii.fType = MFT_STRING;
	mii.cch = strlen(string);
	InsertMenuItem(hMenu, 4, TRUE, &mii);

	/* CgveNg */
	mii.wID = IDM_D0WRITE + offset;
	LoadString(hAppInstance, IDS_DISKPROTECT, string, sizeof(string));
	if (fdc_fwritep[Drive]) {
		mii.fState = MFS_GRAYED;
	}
	else {
		if (fdc_writep[Drive]) {
			mii.fState = MFS_CHECKED | MFS_ENABLED;
		}
		else {
			mii.fState = MFS_ENABLED;
		}
	}
	mii.fType = MFT_STRING;
	mii.cch = strlen(string);
	InsertMenuItem(hMenu, 5, TRUE, &mii);

	/* Zp[^} */
	mii.fType = MFT_SEPARATOR;
	InsertMenuItem(hMenu, 6, TRUE, &mii);

	/* 2D/2DD/VFDȂꏈ */
	if ((fdc_ready[Drive] == FDC_TYPE_2D) ||
#if XM7_VER >= 3
		(fdc_ready[Drive] == FDC_TYPE_2DD) ||
#endif
		(fdc_ready[Drive] == FDC_TYPE_VFD)) {
		mii.wID = IDM_D0MEDIA00 + offset;
		mii.fState = MFS_CHECKED | MFS_ENABLED;
		mii.fType = MFT_STRING | MFT_RADIOCHECK;
		if (fdc_ready[Drive] == FDC_TYPE_2D) {
			LoadString(hAppInstance, IDS_DISK2D, string, sizeof(string));
		}
#if XM7_VER >= 3
		else if (fdc_ready[Drive] == FDC_TYPE_2DD) {
			LoadString(hAppInstance, IDS_DISK2DD, string, sizeof(string));
		}
#endif
		else {
			LoadString(hAppInstance, IDS_DISKVFD, string, sizeof(string));
		}
		mii.cch = strlen(string);
		InsertMenuItem(hMenu, 7, TRUE, &mii);
		return;
	}

	/* fBA */
	uItem = 7;
	for (i=0; i<fdc_medias[Drive]; i++) {
		mii.wID = IDM_D0MEDIA00 + offset + i;
		if (fdc_media[Drive] == i) {
			mii.fState = MFS_CHECKED | MFS_ENABLED;
		}
		else {
			mii.fState = MFS_ENABLED;
		}
		mii.fType = MFT_STRING | MFT_RADIOCHECK;
		if (strlen(fdc_name[Drive][i]) == 0) {
			LoadString(hAppInstance, IDS_MEDIA_NAME, buffer, sizeof(buffer));
			/* 128oCg𒴂ȂƂ͎v̂c */
			_snprintf(string, sizeof(string), buffer, i + 1);
		}
		else {
			/* vtBbNX΍ */
			k = 0;
			for (j=0; j<(int)strlen(fdc_name[Drive][i]); j++) {
				if (fdc_name[Drive][i][j] == '&') {
					string[k++] = '&';
				}
				string[k++] = fdc_name[Drive][i][j];
			}
			string[k] = '\0';
		}
		mii.cch = strlen(string);
		InsertMenuItem(hMenu, uItem++, TRUE, &mii);
	}

	/* } */
	AppendMenuHistory(hMenu, uItem, IDM_D0_FILE0 - Drive * 10, 
		MRU_MFD0 + Drive, TRUE);
}

/*
 *	fBXN(1)(0)ReLXgj[
 */
static BOOL FASTCALL OnDiskContextualMenu(HWND hWnd, WORD wID, int x, int y)
{
	ASSERT(hWnd);

	/* fBXNENbNj[ */
	if ((wID >= IDM_D0MEDIA00) && (wID <= IDM_D0MEDIA15)) {
		OnContextualSubMenu(hWnd, hMediaMenu, wID, x, y);
		return TRUE;
	}
	if ((wID >= IDM_D1MEDIA00) && (wID <= IDM_D1MEDIA15)) {
		OnContextualSubMenu(hWnd, hMediaMenu, wID, x, y);
		return TRUE;
	}

	/* qXg */
	if ((wID >= IDM_D1_FILE0) && (wID <= IDM_D0_FILE9)) {
		OnContextualSubMenu(hWnd, hHistoryMenu, wID, x, y);
		return TRUE;
	}

	return FALSE;
}

/*-[ e[vj[ ]-------------------------------------------------------*/

/*
 *  e[vI[v
 */
static void FASTCALL OnTapeOpen(void)
{
	char path[_MAX_PATH];

	/* t@CI */
	if (!FileSelectSub(TRUE, IDS_TAPEFILTER, path, NULL, TAPE_IMAGE_DIR)) {
		return;
	}

	/* Zbg */
	LockVM();
	tape_setfile(path);
	if (tape_fileh != -1) {
		SetMRUFile(MRU_TAPE, tape_fname);
	}
	ResetSch();
	UnlockVM();
}

/*
 *	e[vCWFNg
 */
static void FASTCALL OnTapeEject(void)
{
	/* CWFNg */
	LockVM();
	tape_setfile(NULL);
	UnlockVM();
}

/*
 *	߂
 */
static void FASTCALL OnRew(void)
{
	HCURSOR hCursor;

	/* ߂ */
	hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
	LockVM();
	StopSnd();

	tape_rew();

	PlaySnd();
	ResetSch();
	UnlockVM();
	SetCursor(hCursor);
}

/*
 *	ŏ܂Ŋ߂
 */
static void FASTCALL OnRewTop(void)
{
	LockVM();
	StopSnd();

	tape_rewtop();

	PlaySnd();
	ResetSch();
	UnlockVM();
}

/*
 *	
 */
static void FASTCALL OnFF(void)
{
	HCURSOR hCursor;

	/* ߂ */
	hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
	LockVM();
	StopSnd();

	tape_ff();

	PlaySnd();
	ResetSch();
	UnlockVM();
	SetCursor(hCursor);
}

/*
 *	^
 */
static void FASTCALL OnRec(void)
{
	/* ^ */
	LockVM();
	if (tape_rec) {
		tape_setrec(FALSE);
	}
	else {
		tape_setrec(TRUE);
	}
	UnlockVM();
}

#if XM7_VER == 1 && defined(BUBBLE)
/*
 *  ouI[v
 */
static void FASTCALL OnBubbleOpen(int unit)
{
	char path[_MAX_PATH];

	ASSERT ((unit == 0) || (unit == 1));

	/* t@CI */
	if (!FileSelectSub(TRUE, IDS_BUBBLEFILTER, path, NULL, BUBBLE_IMAGE_DIR)) {
		return;
	}

	/* Zbg */
	LockVM();
	bmc_setfile(unit, path);
	bmc_setmedia(unit, 0);
	if (bmc_ready[unit] != BMC_TYPE_NOTREADY) {
		SetMRUFile(MRU_BBL0 + unit, bmc_fname[unit]);
	}
	ResetSch();
	UnlockVM();
}


/*
 *  jbgŊJ
 */
static void FASTCALL OnBubbleBoth(void)
{
	char path[_MAX_PATH];

	/* t@CI */
	if (!FileSelectSub(TRUE, IDS_BUBBLEFILTER, path, NULL, BUBBLE_IMAGE_DIR)) {
		return;
	}

	/* Zbg */
	LockVM();
	bmc_setfile(0, path);
	bmc_setfile(1, NULL);
	if (bmc_ready[0] != BMC_TYPE_NOTREADY) {
		SetMRUFile(MRU_BBL0, bmc_fname[0]);
	}
	if ((bmc_ready[0] != BMC_TYPE_NOTREADY) && (bmc_medias[0] >= 2)) {
		bmc_setfile(1, path);
		bmc_setmedia(1, 1);
		if (bmc_ready[1] != BMC_TYPE_NOTREADY) {
			SetMRUFile(MRU_BBL1, bmc_fname[1]);
			SetMRUMedia(MRU_BBL1, bmc_media[1]);
		}
	}
	ResetSch();
	UnlockVM();
}

/*
 *	ouCWFNg
 */
static void FASTCALL OnBubbleEject(int unit)
{
	ASSERT((unit == 0) || (unit == 1));

	/* CWFNg */
	LockVM();
	bmc_setfile(unit, NULL);
	UnlockVM();
}

/*
 *	ouꎞo
 */
static void FASTCALL OnBubbleTemp(int unit)
{
	ASSERT((unit == 0) || (unit == 1));

	/* ݋֎~؂ւ */
	LockVM();
	if (bmc_teject[unit]) {
		bmc_teject[unit] = FALSE;
	}
	else {
		bmc_teject[unit] = TRUE;
	}
	UnlockVM();
}

/*
 *	ou݋֎~
 */
static void FASTCALL OnBubbleProtect(int unit)
{
	ASSERT((unit == 0) || (unit == 1));

	/* ݋֎~؂ւ */
	LockVM();
	if (bmc_writep[unit]) {
		bmc_setwritep(unit, FALSE);
	}
	else {
		bmc_setwritep(unit, TRUE);
	}
	ResetSch();
	UnlockVM();
}
#endif

/*
 *	e[v(A)j[
 */
static BOOL FASTCALL OnTape(WORD wID)
{
	char path[256 + 1];
#if XM7_VER == 1 && defined(BUBBLE)
	int unit;
	int mrutype;
	int index;
	int media;
#endif

	switch (wID) {
		/* J */
		case IDM_TOPEN:
			OnTapeOpen();
			return TRUE;

		/* O */
		case IDM_TEJECT:
			OnTapeEject();
			return TRUE;

		/* ߂ */
		case IDM_REW:
			OnRew();
			return TRUE;

		/* ŏ܂Ŋ߂ */
		case IDM_REWTOP:
			OnRewTop();
			return TRUE;

		/*  */
		case IDM_FF:
			OnFF();
			return TRUE;

		/* ^ */
		case IDM_REC:
			OnRec();
			return TRUE;

#if XM7_VER == 1 && defined(BUBBLE)
		/* J */
		case IDM_B0OPEN:
			OnBubbleOpen(0);
			return TRUE;
		case IDM_B1OPEN:
			OnBubbleOpen(1);
			return TRUE;

		/* jbgŊJ */
		case IDM_BBOPEN:
			OnBubbleBoth();
			break;

		/* O */
		case IDM_B0EJECT:
			OnBubbleEject(0);
			return TRUE;
		case IDM_B1EJECT:
			OnBubbleEject(1);
			return TRUE;

		/* ꎞCWFNg */
		case IDM_B0TEMP:
			OnBubbleTemp(0);
			return TRUE;
		case IDM_B1TEMP:
			OnBubbleTemp(1);
			return TRUE;

		/* ݋֎~ */
		case IDM_B0WRITE:
			OnBubbleProtect(0);
			return TRUE;
		case IDM_B1WRITE:
			OnBubbleProtect(1);
			return TRUE;
#endif
	}

	/* XgZbgie[vj */
	if ((wID >= IDM_T_FILE0) && (wID <= IDM_T_FILE9)) {
		GetMRUFile(MRU_TAPE, wID - IDM_T_FILE0, path, sizeof(path));

		LockVM();
		tape_setfile(path);
		if (tape_fileh != -1) {
			SetMRUFile(MRU_TAPE, tape_fname);
		}
		else {
			FileMessageBox(hMainWnd, IDS_FILE_NOT_FOUND, path, MB_ICONSTOP | MB_OK);
			SetMenuExitTimer();
		}
		ResetSch();
		UnlockVM();
	}

#if XM7_VER == 1 && defined(BUBBLE)
	/* fBAiouJZbgj */
	if ((wID >= IDM_B0MEDIA00) && (wID <= IDM_B0MEDIA15)) {
		LockVM();
		bmc_setmedia(0, wID - IDM_B0MEDIA00);
		SetMRUMedia(MRU_BBL0, bmc_media[0]);
		ResetSch();
		UnlockVM();
		return TRUE;
	}
	if ((wID >= IDM_B1MEDIA00) && (wID <= IDM_B1MEDIA15)) {
		LockVM();
		bmc_setmedia(1, wID - IDM_B1MEDIA00);
		SetMRUMedia(MRU_BBL1, bmc_media[1]);
		ResetSch();
		UnlockVM();
		return TRUE;
	}

	/* XgZbgiouJZbgj */
	if ((wID >= IDM_B1_FILE0) && (wID <= IDM_B0_FILE9)) {
		if ((wID >= IDM_B0_FILE0) && (wID <= IDM_B0_FILE9)) {
			unit	= 0;
			mrutype	= MRU_BBL0;
			index	= wID - IDM_B0_FILE0;
		}
		if ((wID >= IDM_B1_FILE0) && (wID <= IDM_B1_FILE9)) {
			unit	= 1;
			mrutype	= MRU_BBL1;
			index	= wID - IDM_B1_FILE0;
		}

		GetMRUFile(mrutype, index, path, sizeof(path));
		media = GetMRUMedia(mrutype, index);

		LockVM();
		bmc_setfile(unit, path);
		if (bmc_ready[unit] != BMC_TYPE_NOTREADY) {
			SetMRUFile(mrutype, bmc_fname[unit]);
			if (bmc_ready[unit] == BMC_TYPE_B77) {
				if (media >= 0) {
					bmc_setmedia(unit, media);
				}
				SetMRUMedia(mrutype, bmc_media[unit]);
			}
		}
		else {
			FileMessageBox(hMainWnd, IDS_FILE_NOT_FOUND, path, MB_ICONSTOP | MB_OK);
			SetMenuExitTimer();
		}
		ResetSch();
		UnlockVM();
	}
#endif

	return FALSE;
}

/*
 *	e[v(A)j[XV
 */
static void FASTCALL OnTapePopup(HMENU hMenu)
{
#if XM7_VER == 1 && defined(BUBBLE)
#define	_BUBBLE
	HMENU hSubMenu;
	MENUITEMINFO mii;
	char string[128];
	char buffer[256];
	UINT offset;
	int unit;
	int i;
	int j;
	int k;
	UINT uItem;

	ASSERT(hMenu);

	/* JZbgj[1Ԗڂ̃Tuj[nh擾 */
	hSubMenu = GetSubMenu(hMenu, 0);
	uItem = 0;

	/* j[ׂč폜 */
	while (GetMenuItemCount(hSubMenu) > 0) {
		DeleteMenu(hSubMenu, 0, MF_BYPOSITION);
	}

	/* j[\̏ */
	memset(&mii, 0, sizeof(mii));
	mii.cbSize = 44;	/* sizeof(mii)WINVER>=0x0500 */
	mii.fMask = MIIM_TYPE | MIIM_STATE | MIIM_ID;
	mii.fType = MFT_STRING;
	mii.fState = MFS_ENABLED;

	/* J */
	mii.wID = IDM_TOPEN;
	LoadString(hAppInstance, IDS_TAPEOPEN, string, sizeof(string));
	mii.dwTypeData = string;
	mii.cch = strlen(string);
	InsertMenuItem(hSubMenu, uItem++, TRUE, &mii);

	/* e[vZbgĂȂ΁A܂ */
	if (tape_fileh != -1) {
		/* o */
		mii.wID = IDM_TEJECT;
		LoadString(hAppInstance, IDS_TAPEEJECT, string, sizeof(string));
		mii.cch = strlen(string);
		InsertMenuItem(hSubMenu, uItem++, TRUE, &mii);

		/* Zp[^} */
		mii.fType = MFT_SEPARATOR;
		InsertMenuItem(hSubMenu, uItem++, TRUE, &mii);
		mii.fType = MFT_STRING;

		/* ߂ */
		mii.wID = IDM_REW;
		LoadString(hAppInstance, IDS_TAPEREW, string, sizeof(string));
		mii.cch = strlen(string);
		InsertMenuItem(hSubMenu, uItem++, TRUE, &mii);

		/* ŏ܂Ŋ߂ */
		mii.wID = IDM_REWTOP;
		LoadString(hAppInstance, IDS_TAPEREWTOP, string, sizeof(string));
		mii.cch = strlen(string);
		InsertMenuItem(hSubMenu, uItem++, TRUE, &mii);

		/*  */
		mii.wID = IDM_FF;
		LoadString(hAppInstance, IDS_TAPEFF, string, sizeof(string));
		mii.cch = strlen(string);
		InsertMenuItem(hSubMenu, uItem++, TRUE, &mii);

		/* Zp[^} */
		mii.fType = MFT_SEPARATOR;
		InsertMenuItem(hSubMenu, uItem++, TRUE, &mii);
		mii.fType = MFT_STRING;

		/* ^ */
		mii.wID = IDM_REC;
		LoadString(hAppInstance, IDS_TAPEREC, string, sizeof(string));
		mii.cch = strlen(string);
		if (tape_writep) {
			mii.fState = MFS_GRAYED;
		}
		else {
			if (tape_rec) {
				mii.fState = MFS_CHECKED | MFS_ENABLED;
			}
			else {
				mii.fState = MFS_ENABLED;
			}
		}
		InsertMenuItem(hSubMenu, uItem++, TRUE, &mii);
	}

	/* } */
	AppendMenuHistory(hSubMenu, uItem, IDM_T_FILE0, MRU_TAPE, TRUE);

	/* ou Tuj[ */
	for (unit = 0; unit < 2; unit ++) 
	{
		uItem = 0;
		hSubMenu = GetSubMenu(hMenu, unit + 1);

		/* j[ׂč폜 */
		while (GetMenuItemCount(hSubMenu) > 0) {
			DeleteMenu(hSubMenu, 0, MF_BYPOSITION);
		}

		/* ItZbgm */
		if (unit == 0) {
			offset = 0;
		}
		else {
			offset = IDM_B1OPEN - IDM_B0OPEN;
		}

		/* j[\̏ */
		memset(&mii, 0, sizeof(mii));
		mii.cbSize = 44;	/* sizeof(mii)WINVER>=0x0500 */
		mii.fMask = MIIM_TYPE | MIIM_STATE | MIIM_ID;
		mii.fType = MFT_STRING;

		/* J */
		mii.wID = IDM_B0OPEN + offset;
		LoadString(hAppInstance, IDS_BUBBLEOPEN, string, sizeof(string));
		mii.dwTypeData = string;
		mii.fState = MFS_ENABLED;
		mii.cch = strlen(string);
		if (!bmc_enable || (fm_subtype != FMSUB_FM8)) {
			mii.fState = MFS_GRAYED;
		}
		else {
			mii.fState = MFS_ENABLED;
		}
		InsertMenuItem(hSubMenu, uItem++, TRUE, &mii);

		if (bmc_enable) {
			/* I[v */
			mii.fMask = MIIM_TYPE | MIIM_STATE | MIIM_ID;
			mii.wID = IDM_BBOPEN;
			LoadString(hAppInstance, IDS_BBOPEN, string, sizeof(string));
			mii.cch = strlen(string);
			InsertMenuItem(hSubMenu, uItem++, TRUE, &mii);

			if (bmc_ready[unit] != BMC_TYPE_NOTREADY) {
				/* o */
				mii.wID = IDM_B0EJECT + offset;
				LoadString(hAppInstance, IDS_BUBBLEEJECT, string, sizeof(string));
				mii.cch = strlen(string);
				InsertMenuItem(hSubMenu, uItem++, TRUE, &mii);

				/* Zp[^} */
				mii.fType = MFT_SEPARATOR;
				InsertMenuItem(hSubMenu, uItem++, TRUE, &mii);

				/* ꎞo */
				mii.wID = IDM_B0TEMP + offset;
				LoadString(hAppInstance, IDS_BUBBLETEMP, string, sizeof(string));
				if ((bmc_ready[unit] == BMC_TYPE_NOTREADY) || (fm_subtype != FMSUB_FM8)) {
					mii.fState = MFS_GRAYED;
				}
				else if (bmc_teject[unit]) {
					mii.fState = MFS_CHECKED | MFS_ENABLED;
				}
				else {
					mii.fState = MFS_ENABLED;
				}
				mii.fType = MFT_STRING;
				mii.cch = strlen(string);
				InsertMenuItem(hSubMenu, uItem++, TRUE, &mii);

				/* ݋֎~ */
				mii.wID = IDM_B0WRITE + offset;
				LoadString(hAppInstance, IDS_BUBBLEPROTECT, string, sizeof(string));
				if ((bmc_ready[unit] == BMC_TYPE_NOTREADY) || (fm_subtype != FMSUB_FM8)) {
					mii.fState = MFS_GRAYED;
				}
				else {
					if (bmc_fwritep[unit]) {
						mii.fState = MFS_GRAYED;
					}
					else {
						mii.fState = MFS_ENABLED;
					}
					if ((bmc_fwritep[unit]) || (bmc_writep[unit])) {
						mii.fState |= MFS_CHECKED;
					}
				}
				mii.fType = MFT_STRING;
				mii.cch = strlen(string);
				InsertMenuItem(hSubMenu, uItem++, TRUE, &mii);

				/* Zp[^} */
				mii.fType = MFT_SEPARATOR;
				InsertMenuItem(hSubMenu, uItem++, TRUE, &mii);

				/* B77Ȃ烁fBA */
				if (bmc_ready[unit] == BMC_TYPE_B77) {
					for (i=0; i<bmc_medias[unit]; i++) {
						if (unit == 0) {
							mii.wID = IDM_B0MEDIA00 + i;
						}
						else {
							mii.wID = IDM_B1MEDIA00 + i;
						}
						mii.fState = MFS_ENABLED;
						if (bmc_media[unit] == i) {
							mii.fState |= MFS_CHECKED;
						}
						mii.fType = MFT_STRING | MFT_RADIOCHECK;
						if (strlen(bmc_name[unit][i]) == 0) {
							LoadString(hAppInstance, IDS_MEDIA_NAME, buffer, sizeof(buffer));
							_snprintf(string, sizeof(string), buffer, i + 1);
						}
						else {
							/* vtBbNX΍ */
							k = 0;
							for (j=0; j<(int)strlen(bmc_name[unit][i]); j++) {
								if (bmc_name[unit][i][j] == '&') {
									string[k++] = '&';
								}
								string[k++] = bmc_name[unit][i][j];
							}
							string[k] = '\0';
						}
						mii.cch = strlen(string);
						InsertMenuItem(hSubMenu, uItem++, TRUE, &mii);
					}
				}
				else {
					/* BBLt@CȂ_~[ڔ */
					if (unit == 0) {
						mii.wID = IDM_B0MEDIA00;
					}
					else {
						mii.wID = IDM_B1MEDIA00;
					}
					mii.fState = MFS_ENABLED | MFS_CHECKED;
					mii.fType = MFT_STRING | MFT_RADIOCHECK;
					LoadString(hAppInstance, IDS_BBLFILE, string, sizeof(string));
					mii.cch = strlen(string);
					InsertMenuItem(hSubMenu, uItem++, TRUE, &mii);
				}
			}
		}

		AppendMenuHistory(hSubMenu, uItem++, IDM_B0_FILE0 - unit * 10, 
			MRU_BBL0 + unit, TRUE);
	}

	EnableMenuPos(hMenu, 1, (fm_subtype == FMSUB_FM8));
	EnableMenuPos(hMenu, 2, (fm_subtype == FMSUB_FM8));
#endif

#ifndef _BUBBLE
	MENUITEMINFO mii;
	char string[128];
	UINT uItem;

	ASSERT(hMenu);

	/* j[ׂč폜 */
	while (GetMenuItemCount(hMenu) > 0) {
		DeleteMenu(hMenu, 0, MF_BYPOSITION);
	}

	/* j[\̏ */
	memset(&mii, 0, sizeof(mii));
	mii.cbSize = 44;	/* sizeof(mii)WINVER>=0x0500 */
	mii.fMask = MIIM_TYPE | MIIM_STATE | MIIM_ID;
	mii.fType = MFT_STRING;
	mii.fState = MFS_ENABLED;
	uItem = 0;

	/* I[v */
	mii.wID = IDM_TOPEN;
	LoadString(hAppInstance, IDS_TAPEOPEN, string, sizeof(string));
	mii.dwTypeData = string;
	mii.cch = strlen(string);
	InsertMenuItem(hMenu, uItem++, TRUE, &mii);

	/* e[vZbgĂȂ΁A܂ */
	if (tape_fileh != -1) {
		/* CWFNg */
		mii.wID = IDM_TEJECT;
		LoadString(hAppInstance, IDS_TAPEEJECT, string, sizeof(string));
		mii.cch = strlen(string);
		InsertMenuItem(hMenu, uItem++, TRUE, &mii);

		/* Zp[^} */
		mii.fType = MFT_SEPARATOR;
		InsertMenuItem(hMenu, uItem++, TRUE, &mii);
		mii.fType = MFT_STRING;

		/* ߂ */
		mii.wID = IDM_REW;
		LoadString(hAppInstance, IDS_TAPEREW, string, sizeof(string));
		mii.cch = strlen(string);
		InsertMenuItem(hMenu, uItem++, TRUE, &mii);

		/* ŏ܂Ŋ߂ */
		mii.wID = IDM_REWTOP;
		LoadString(hAppInstance, IDS_TAPEREWTOP, string, sizeof(string));
		mii.cch = strlen(string);
		InsertMenuItem(hMenu, uItem++, TRUE, &mii);

		/*  */
		mii.wID = IDM_FF;
		LoadString(hAppInstance, IDS_TAPEFF, string, sizeof(string));
		mii.cch = strlen(string);
		InsertMenuItem(hMenu, uItem++, TRUE, &mii);

		/* Zp[^} */
		mii.fType = MFT_SEPARATOR;
		InsertMenuItem(hMenu, uItem++, TRUE, &mii);
		mii.fType = MFT_STRING;

		/* ^ */
		mii.wID = IDM_REC;
		LoadString(hAppInstance, IDS_TAPEREC, string, sizeof(string));
		mii.cch = strlen(string);
		if (tape_writep) {
			mii.fState = MFS_GRAYED;
		}
		else {
			if (tape_rec) {
				mii.fState = MFS_CHECKED | MFS_ENABLED;
			}
			else {
				mii.fState = MFS_ENABLED;
			}
		}
		InsertMenuItem(hMenu, uItem++, TRUE, &mii);
	}

	/* } */
	AppendMenuHistory(hMenu, uItem, IDM_T_FILE0, MRU_TAPE, TRUE);
#endif

#undef _BUBBLE
}

/*
 *	e[v(A)ReLXgj[
 */
static BOOL FASTCALL OnTapeContextualMenu(HWND hWnd, WORD wID, int x, int y)
{
	ASSERT(hWnd);

#if XM7_VER == 1 && defined(BUBBLE)
	/* ouJZbgENbNj[ */
	if ((wID >= IDM_B0MEDIA00) && (wID <= IDM_B0MEDIA15)) {
		OnContextualSubMenu(hWnd, hMediaMenu, wID, x, y);
		return TRUE;
	}
	if ((wID >= IDM_B1MEDIA00) && (wID <= IDM_B1MEDIA15)) {
		OnContextualSubMenu(hWnd, hMediaMenu, wID, x, y);
		return TRUE;
	}
#endif	/* XM7_VER == 1 && defined(BUBBLE) */

	/* qXg */
	if ((wID >= IDM_T_FILE0) && (wID <= IDM_T_FILE9)) {
		OnContextualSubMenu(hWnd, hHistoryMenu, wID, x, y);
		return TRUE;
	}
#if XM7_VER == 1 && defined(BUBBLE)
	if ((wID >= IDM_B1_FILE0) && (wID <= IDM_B0_FILE9)) {
		OnContextualSubMenu(hWnd, hHistoryMenu, wID, x, y);
		return TRUE;
	}
#endif	/* XM7_VER == 1 && defined(BUBBLE) */

	return FALSE;
}


/*-[ \j[ ]---------------------------------------------------------*/

/*
 *	tbs[fBXNRg[(F)
 */
static void FASTCALL OnFDC(void)
{
	ASSERT(hDrawWnd);

	/* EChE݂΁AN[Ywo */
	if (hSubWnd[SWND_FDC]) {
		PostMessage(hSubWnd[SWND_FDC], WM_CLOSE, 0, 0);
		return;
	}

	/* EChE쐬 */
	hSubWnd[SWND_FDC] = CreateFDC(hDrawWnd, SWND_FDC);
}

/*
 *	ouRg[(B)
 */
#if XM7_VER == 1 && defined(BUBBLE)
static void FASTCALL OnBMC(void)
{
	ASSERT(hDrawWnd);

	/* EChE݂΁AN[Ywo */
	if (hSubWnd[SWND_BMC]) {
		PostMessage(hSubWnd[SWND_BMC], WM_CLOSE, 0, 0);
		return;
	}

	/* EChE쐬 */
	hSubWnd[SWND_BMC] = CreateBMC(hDrawWnd, SWND_BMC);
}
#endif

/*
 *	FMWX^(O)
 */
static void FASTCALL OnOPNReg(void)
{
	ASSERT(hDrawWnd);

	/* EChE݂΁AN[Ywo */
	if (hSubWnd[SWND_OPNREG]) {
		PostMessage(hSubWnd[SWND_OPNREG], WM_CLOSE, 0, 0);
		return;
	}

	/* EChE쐬 */
	hSubWnd[SWND_OPNREG] = CreateOPNReg(hDrawWnd, SWND_OPNREG);
}

/*
 *	FMfBXvC(D)
 */
static void FASTCALL OnOPNDisp(void)
{
	ASSERT(hDrawWnd);

	/* EChE݂΁AN[Ywo */
	if (hSubWnd[SWND_OPNDISP]) {
		PostMessage(hSubWnd[SWND_OPNDISP], WM_CLOSE, 0, 0);
		return;
	}

	/* EChE쐬 */
	hSubWnd[SWND_OPNDISP] = CreateOPNDisp(hDrawWnd, SWND_OPNDISP);
}

/*
 *	TuCPURg[(C)
 */
static void FASTCALL OnSubCtrl(void)
{
	ASSERT(hDrawWnd);

	/* EChE݂΁AN[Ywo */
	if (hSubWnd[SWND_SUBCTRL]) {
		PostMessage(hSubWnd[SWND_SUBCTRL], WM_CLOSE, 0, 0);
		return;
	}

	/* EChE쐬 */
	hSubWnd[SWND_SUBCTRL] = CreateSubCtrl(hDrawWnd, SWND_SUBCTRL);
}

/*
 *	pbgWX^(P)
 */
static void FASTCALL OnPaletteReg(void)
{
	ASSERT(hDrawWnd);

	/* EChE݂΁AN[Ywo */
	if (hSubWnd[SWND_PALETTE]) {
		PostMessage(hSubWnd[SWND_PALETTE], WM_CLOSE, 0, 0);
		return;
	}

	/* EChE쐬 */
	hSubWnd[SWND_PALETTE] = CreatePaletteReg(hDrawWnd, SWND_PALETTE);
}

	/*
 *	L[{[h(K)
 */
static void FASTCALL OnKeyboard(void)
{
	ASSERT(hDrawWnd);

	/* EChE݂΁AN[Ywo */
	if (hSubWnd[SWND_KEYBOARD]) {
		PostMessage(hSubWnd[SWND_KEYBOARD], WM_CLOSE, 0, 0);
		return;
	}

	/* EChE쐬 */
	hSubWnd[SWND_KEYBOARD] = CreateKeyboard(hDrawWnd, SWND_KEYBOARD);
}

/*
 *	_Z/(L)
 */
#if XM7_VER >= 2
static void FASTCALL OnALULine(void)
{
	ASSERT(hDrawWnd);

	/* EChE݂΁AN[Ywo */
	if (hSubWnd[SWND_ALULINE]) {
		PostMessage(hSubWnd[SWND_ALULINE], WM_CLOSE, 0, 0);
		return;
	}

	/* EChE쐬 */
	hSubWnd[SWND_ALULINE] = CreateALULine(hDrawWnd, SWND_ALULINE);
}
#endif

/*
 *	Ǘ(M)
 */
static void FASTCALL OnMMR(void)
{
	ASSERT(hDrawWnd);

	/* EChE݂΁AN[Ywo */
	if (hSubWnd[SWND_MMR]) {
		PostMessage(hSubWnd[SWND_MMR], WM_CLOSE, 0, 0);
		return;
	}

	/* EChE쐬 */
	hSubWnd[SWND_MMR] = CreateMMR(hDrawWnd, SWND_MMR);
}

#if XM7_VER >= 3
/*
 *	DMARg[(A)
 */
static void FASTCALL OnDMAC(void)
{
	ASSERT(hDrawWnd);

	/* EChE݂΁AN[Ywo */
	if (hSubWnd[SWND_DMAC]) {
		PostMessage(hSubWnd[SWND_DMAC], WM_CLOSE, 0, 0);
		return;
	}

	/* EChE쐬 */
	hSubWnd[SWND_DMAC] = CreateDMAC(hDrawWnd, SWND_DMAC);
}
#endif

/*
 *	Xe[^Xo[(S)
 */
static void FASTCALL OnStatus(void)
{
	/* Xe[^Xo[LłȂ΁AȂ */
	if (!hStatusBar) {
		return;
	}

	if (IsWindowVisible(hStatusBar)) {
		/*  */
		ShowWindow(hStatusBar, SW_HIDE);
		bHideStatus = TRUE;
	}
	else {
		/* \ */
		ShowWindow(hStatusBar, SW_SHOW);
		bHideStatus = FALSE;
	}

	/* ݒ胏[Nɔf */
	GetCfg();

	/* t[EChẼTCY␳ */
	OnSize(hMainWnd, 640, 400);
}

/*
 *	ŐV̏ɍXV(R)
 */
void FASTCALL OnRefresh(HWND hWnd)
{
	int i;

	ASSERT(hWnd);
	ASSERT(hDrawWnd);

	/* tAZuEChE@AhXXV */
	if ((hSubWnd[SWND_DISASM_MAIN]) && (bSyncDisasm[0])) {
		AddrDisAsm(MAINCPU, maincpu.pc);
	}
	if ((hSubWnd[SWND_DISASM_SUB]) && (bSyncDisasm[1])) {
		AddrDisAsm(SUBCPU, subcpu.pc);
	}
#if XM7_VER == 1 && defined(JSUB)
	if ((hSubWnd[SWND_DISASM_JSUB]) && (bSyncDisasm[2])) {
		AddrDisAsm(JSUBCPU, jsubcpu.pc);
	}
#endif

	/* FM/PSGWX^/fBXvCEChEXV */
	ReSizeOPNReg();
	ReSizeOPNDisp();

	/* CEChE */
	InvalidateRect(hWnd, NULL, FALSE);
	InvalidateRect(hDrawWnd, NULL, FALSE);

	/* TuEChE */
	for (i=0; i<SWND_MAXNUM; i++) {
		if (hSubWnd[i]) {
			InvalidateRect(hSubWnd[i], NULL, FALSE);
		}
	}
}

/*
 *	sɓ(Y)
 */
static void FASTCALL OnSync(void)
{
	bSync = (!bSync);
}

/*
 *	tXN[(U)
 */
static void FASTCALL OnFullScreen(HWND hWnd)
{
	BOOL bRun;
	int i;

	ASSERT(hWnd);

#ifdef KBDPASTE
	if (hKeyStrokeDialog) {
		/* EChEN[Y */
		PostMessage(hKeyStrokeDialog, WM_CLOSE, 0, 0);
		Sleep(1);
	}
#endif

	/* VMbNAXgbv */
	LockVM();
	bRun = run_flag;
	run_flag = FALSE;
	StopSnd();

	/* [h؂ւ */
	if (bFullScreen) {
		ModeDraw(hWnd, FALSE);

		if (!bFullScreen) {
			/* ׂẴTuEBhEtXN[ȌԂɖ߂ */
			for (i=0; i<SWND_MAXNUM; i++) {
				if (hSubWnd[i]) {
					if (bShowSubWindow[i]) {
						ShowWindow(hSubWnd[i], SW_RESTORE);
					}
				}
			}
			if (bPopupSwnd) {
				SetForegroundWindow(hWnd);
			}
		}
	}
	else {
		ModeDraw(hWnd, TRUE);

		if (bFullScreen) {
			/* ׂẴTuEBhEB */
			for (i=0; i<SWND_MAXNUM; i++) {
				bShowSubWindow[i] = FALSE;
				if (hSubWnd[i]) {
					if (ShowWindow(hSubWnd[i], SW_HIDE)) {
						bShowSubWindow[i] = TRUE;
					}
				}
			}
		}
	}

	/* VMAbN */
	GetCfg();
	run_flag = bRun;
	ResetSch();
	UnlockVM();
	PlaySnd();
}

/*
 *	\(V)j[
 */
static BOOL FASTCALL OnView(HWND hWnd, WORD wID)
{
	ASSERT(hWnd);

	switch (wID) {
		/* FDC */
		case IDM_FDC:
			OnFDC();
			return TRUE;

		/* ouRg[ */
#if XM7_VER == 1 && defined(BUBBLE)
		case IDM_BMC:
			OnBMC();
			return TRUE;
#endif

		/* OPNWX^ */
		case IDM_OPNREG:
			OnOPNReg();
			return TRUE;

		/* OPNfBXvC */
		case IDM_OPNDISP:
			OnOPNDisp();
			return TRUE;

		/* TuCPURg[ */
		case IDM_SUBCTRL:
			OnSubCtrl();
			return TRUE;

		/* pbgWX^ */
		case IDM_PALETTE:
			OnPaletteReg();
			return TRUE;

		/* L[{[h */
		case IDM_KEYBOARD:
			OnKeyboard();
			return TRUE;

#if XM7_VER >= 2
		/* _Z/ */
		case IDM_ALULINE:
			OnALULine();
			return TRUE;
#endif

		/* Ǘ */
		case IDM_MMR:
			OnMMR();
			return TRUE;

#if XM7_VER >= 3
		/* DMARg[ */
		case IDM_DMAC:
			OnDMAC();
			return TRUE;
#endif

		/* Xe[^Xo[ */
		case IDM_STATUS:
			OnStatus();
			return TRUE;

		/* ŐV̏ɍXV */
		case IDM_REFRESH:
			OnRefresh(hWnd);
			return TRUE;

		/* sɓ */
		case IDM_SYNC:
			OnSync();
			return TRUE;

		/* tXN[ */
		case IDM_FULLSCREEN:
			OnFullScreen(hWnd);
			return TRUE;
	}

	return FALSE;
}

/*
 *	\(V)j[XV
 */
static void FASTCALL OnViewPopup(HMENU hMenu)
{
	/* TuEChEQ */
	CheckMenuSub(hMenu, IDM_FDC, (BOOL)hSubWnd[SWND_FDC]);
#if XM7_VER == 1 && defined(BUBBLE)
	CheckMenuSub(hMenu, IDM_BMC, (BOOL)hSubWnd[SWND_BMC]);
#endif
	CheckMenuSub(hMenu, IDM_OPNREG, (BOOL)hSubWnd[SWND_OPNREG]);
	CheckMenuSub(hMenu, IDM_OPNDISP, (BOOL)hSubWnd[SWND_OPNDISP]);
	CheckMenuSub(hMenu, IDM_PALETTE, (BOOL)hSubWnd[SWND_PALETTE]);
	CheckMenuSub(hMenu, IDM_SUBCTRL, (BOOL)hSubWnd[SWND_SUBCTRL]);
#if XM7_VER >= 2
	CheckMenuSub(hMenu, IDM_ALULINE, (BOOL)hSubWnd[SWND_ALULINE]);
#endif
	CheckMenuSub(hMenu, IDM_KEYBOARD, (BOOL)hSubWnd[SWND_KEYBOARD]);
	CheckMenuSub(hMenu, IDM_MMR, (BOOL)hSubWnd[SWND_MMR]);
#if XM7_VER >= 3
	CheckMenuSub(hMenu, IDM_DMAC, (BOOL)hSubWnd[SWND_DMAC]);
#endif

	/* ̑ */
	if (hStatusBar) {
		CheckMenuSub(hMenu, IDM_STATUS, IsWindowVisible(hStatusBar));
	}
	else {
		CheckMenuSub(hMenu, IDM_STATUS, FALSE);
	}
	CheckMenuSub(hMenu, IDM_SYNC, bSync);
	CheckMenuSub(hMenu, IDM_FULLSCREEN, bFullScreen);

	/* tXN[̃TuEBhEj[ */
	EnableMenuSub(hMenu, IDM_FDC, !bFullScreen);
#if XM7_VER == 1 && defined(BUBBLE)
	EnableMenuSub(hMenu, IDM_BMC, !bFullScreen);
#endif
	EnableMenuSub(hMenu, IDM_OPNREG, !bFullScreen);
	EnableMenuSub(hMenu, IDM_OPNDISP, !bFullScreen);
	EnableMenuSub(hMenu, IDM_PALETTE, !bFullScreen);
	EnableMenuSub(hMenu, IDM_SUBCTRL, !bFullScreen);
#if XM7_VER >= 2
	EnableMenuSub(hMenu, IDM_ALULINE, !bFullScreen);
#endif
	EnableMenuSub(hMenu, IDM_KEYBOARD, !bFullScreen);
	EnableMenuSub(hMenu, IDM_MMR, !bFullScreen);
#if XM7_VER >= 3
	EnableMenuSub(hMenu, IDM_DMAC, !bFullScreen);
#endif
}

/*-[ fobOj[ ]-----------------------------------------------------*/

/*
 *	s(X)
 */
static void FASTCALL OnExec(void)
{
	/* ɎsȂAȂ */
	if (run_flag) {
		return;
	}

	/* X^[g */
	LockVM();
	stopreq_flag = FALSE;
	run_flag = TRUE;
	UnlockVM();
}

/*
 *	~(B)
 */
static void FASTCALL OnBreak(void)
{
	/* ɒ~ԂȂAȂ */
	if (!run_flag) {
		return;
	}

	/* ~ */
	LockVM();
	stopreq_flag = TRUE;
	UnlockVM();
}

/*
 *	g[X(T)
 */
static void FASTCALL OnTrace(HWND hWnd)
{
	ASSERT(hWnd);

	/* ~ԂłȂ΁A^[ */
	if (run_flag) {
		return;
	}

	/* s */
	schedule_trace();
	AddrDisAsm(MAINCPU, maincpu.pc);
	AddrDisAsm(SUBCPU, subcpu.pc);
#if XM7_VER == 1 && defined(JSUB)
	AddrDisAsm(JSUBCPU, jsubcpu.pc);
#endif

	/* \XV */
	OnRefresh(hWnd);
}

/*
 *	u[N|Cg(B)
 */
static void FASTCALL OnBreakPoint(void)
{
	ASSERT(hDrawWnd);

	/* EChE݂΁AN[Ywo */
	if (hSubWnd[SWND_BREAKPOINT]) {
		PostMessage(hSubWnd[SWND_BREAKPOINT], WM_CLOSE, 0, 0);
		return;
	}

	/* EChE쐬 */
	hSubWnd[SWND_BREAKPOINT] = CreateBreakPoint(hDrawWnd, SWND_BREAKPOINT);
}

/*
 *	XPW[(S)
 */
static void FASTCALL OnScheduler(void)
{
	ASSERT(hDrawWnd);

	/* EChE݂΁AN[Ywo */
	if (hSubWnd[SWND_SCHEDULER]) {
		PostMessage(hSubWnd[SWND_SCHEDULER], WM_CLOSE, 0, 0);
		return;
	}

	/* EChE쐬 */
	hSubWnd[SWND_SCHEDULER] = CreateScheduler(hDrawWnd, SWND_SCHEDULER);
}

/*
 *	CPUWX^(C)
 */
static void FASTCALL OnCPURegister(int nCPU)
{
	int index;

#if XM7_VER >= 2
	ASSERT((nCPU >= MAINCPU) && (nCPU <= SUBCPU));
#elif defined(Z80CARD)
	ASSERT((nCPU >= MAINCPU) && (nCPU <= MAINZ80));
#else
	ASSERT((nCPU >= MAINCPU) && (nCPU <= JSUBCPU));
#endif
	ASSERT(hDrawWnd);

	/* CfbNX */
	index = SWND_CPUREG_MAIN + nCPU;

	/* EChE݂΁AN[Ywo */
	if (hSubWnd[index]) {
		PostMessage(hSubWnd[index], WM_CLOSE, 0, 0);
		return;
	}

	/* EChE쐬 */
	hSubWnd[index] = CreateCPURegister(hDrawWnd, (BYTE)nCPU, index);
}

/*
 *	tAZu(D)
 */
static void FASTCALL OnDisAsm(int nCPU)
{
	int index;

#if XM7_VER >= 2
	ASSERT((nCPU >= MAINCPU) && (nCPU <= SUBCPU));
#elif defined(Z80CARD)
	ASSERT((nCPU >= MAINCPU) && (nCPU <= MAINZ80));
#else
	ASSERT((nCPU >= MAINCPU) && (nCPU <= JSUBCPU));
#endif
	ASSERT(hDrawWnd);

	/* CfbNX */
	index = SWND_DISASM_MAIN + nCPU;

	/* EChE݂΁AN[Ywo */
	if (hSubWnd[index]) {
		PostMessage(hSubWnd[index], WM_CLOSE, 0, 0);
		return;
	}

	/* EChE쐬 */
	hSubWnd[index] = CreateDisAsm(hDrawWnd, (BYTE)nCPU, index);
}

/*
 *	_v(M)
 */
static void FASTCALL OnMemory(int nCPU)
{
	int index;

#if XM7_VER >= 2
	ASSERT((nCPU >= MAINCPU) && (nCPU <= SUBCPU));
#else
	/* ̃P[X̂Z80[hpEChE݂͑Ȃ */
	ASSERT((nCPU >= MAINCPU) && (nCPU <= JSUBCPU));
#endif
	ASSERT(hDrawWnd);

	/* CfbNX */
	index = SWND_MEMORY_MAIN + nCPU;

	/* EChE݂΁AN[Ywo */
	if (hSubWnd[index]) {
		PostMessage(hSubWnd[index], WM_CLOSE, 0, 0);
		return;
	}

	/* EChE쐬 */
	hSubWnd[index] = CreateMemory(hDrawWnd, (BYTE)nCPU, index);
}

/*
 *	fobO(D)j[
 */
static BOOL FASTCALL OnDebug(HWND hWnd, WORD wID)
{
	ASSERT(hWnd);

	switch (wID) {
		/* s */
		case IDM_EXEC:
			OnExec();
			return TRUE;

		/* u[N */
		case IDM_BREAK:
			OnBreak();
			return TRUE;

		/* g[X */
		case IDM_TRACE:
			OnTrace(hWnd);
			return TRUE;

		/* u[N|Cg */
		case IDM_BREAKPOINT:
			OnBreakPoint();
			return TRUE;

		/* XPW[ */
		case IDM_SCHEDULER:
			OnScheduler();
			return TRUE;

		/* CPUWX^(C) */
		case IDM_CPU_MAIN:
			OnCPURegister(MAINCPU);
			return TRUE;

		/* CPUWX^(Tu) */
		case IDM_CPU_SUB:
			OnCPURegister(SUBCPU);
			return TRUE;

		/* tAZu(C) */
		case IDM_DISASM_MAIN:
			OnDisAsm(MAINCPU);
			return TRUE;

		/* tAZu(Tu) */
		case IDM_DISASM_SUB:
			OnDisAsm(SUBCPU);
			return TRUE;

		/* _v(C) */
		case IDM_MEMORY_MAIN:
			OnMemory(MAINCPU);
			return TRUE;

		/* _v(Tu) */
		case IDM_MEMORY_SUB:
			OnMemory(SUBCPU);
			return TRUE;

#if XM7_VER == 1
#ifdef JSUB
		/* CPUWX^({Tu) */
		case IDM_CPU_JSUB:
			OnCPURegister(JSUBCPU);
			return TRUE;

		/* tAZu({Tu) */
		case IDM_DISASM_JSUB:
			OnDisAsm(JSUBCPU);
			return TRUE;

		/* _v({Tu) */
		case IDM_MEMORY_JSUB:
			OnMemory(JSUBCPU);
			return TRUE;
#endif

#ifdef Z80CARD
		/* CPUWX^(CZ80) */
		case IDM_CPU_MAINZ80:
			OnCPURegister(MAINZ80);
			return TRUE;

		/* tAZu(CZ80) */
		case IDM_DISASM_MAINZ80:
			OnDisAsm(MAINZ80);
			return TRUE;
#endif
#endif
	}

	return FALSE;
}

/*
 *	fobO(D)j[XV
 */
static void FASTCALL OnDebugPopup(HMENU hMenu)
{
	ASSERT(hMenu);

	/* s */
	EnableMenuSub(hMenu, IDM_EXEC, !run_flag);
	EnableMenuSub(hMenu, IDM_BREAK, run_flag);
	EnableMenuSub(hMenu, IDM_TRACE, !run_flag);

	/* TuEChEQ */
	CheckMenuSub(hMenu, IDM_BREAKPOINT, (BOOL)hSubWnd[SWND_BREAKPOINT]);
	CheckMenuSub(hMenu, IDM_SCHEDULER, (BOOL)hSubWnd[SWND_SCHEDULER]);
	CheckMenuSub(hMenu, IDM_CPU_MAIN, (BOOL)hSubWnd[SWND_CPUREG_MAIN]);
	CheckMenuSub(hMenu, IDM_CPU_SUB, (BOOL)hSubWnd[SWND_CPUREG_SUB]);
	CheckMenuSub(hMenu, IDM_DISASM_MAIN, (BOOL)hSubWnd[SWND_DISASM_MAIN]);
	CheckMenuSub(hMenu, IDM_DISASM_SUB, (BOOL)hSubWnd[SWND_DISASM_SUB]);
	CheckMenuSub(hMenu, IDM_MEMORY_MAIN, (BOOL)hSubWnd[SWND_MEMORY_MAIN]);
	CheckMenuSub(hMenu, IDM_MEMORY_SUB, (BOOL)hSubWnd[SWND_MEMORY_SUB]);
#if XM7_VER == 1 
#ifdef JSUB
	CheckMenuSub(hMenu, IDM_CPU_JSUB, (BOOL)hSubWnd[SWND_CPUREG_JSUB]);
	CheckMenuSub(hMenu, IDM_DISASM_JSUB, (BOOL)hSubWnd[SWND_DISASM_JSUB]);
	CheckMenuSub(hMenu, IDM_MEMORY_JSUB, (BOOL)hSubWnd[SWND_MEMORY_JSUB]);
#endif
#ifdef Z80CARD
	CheckMenuSub(hMenu, IDM_CPU_MAINZ80, (BOOL)hSubWnd[SWND_CPUREG_Z80]);
	CheckMenuSub(hMenu, IDM_DISASM_MAINZ80, (BOOL)hSubWnd[SWND_DISASM_Z80]);
#endif
#endif

	/* tXN[̃TuEBhEj[ */
	EnableMenuSub(hMenu, IDM_BREAKPOINT, !bFullScreen);
	EnableMenuSub(hMenu, IDM_SCHEDULER, !bFullScreen);
	EnableMenuSub(hMenu, IDM_CPU_MAIN, !bFullScreen);
	EnableMenuSub(hMenu, IDM_CPU_SUB, !bFullScreen);
	EnableMenuSub(hMenu, IDM_DISASM_MAIN, !bFullScreen);
	EnableMenuSub(hMenu, IDM_DISASM_SUB, !bFullScreen);
	EnableMenuSub(hMenu, IDM_MEMORY_MAIN, !bFullScreen);
	EnableMenuSub(hMenu, IDM_MEMORY_SUB, !bFullScreen);
#if XM7_VER == 1 
#ifdef JSUB
	EnableMenuSub(hMenu, IDM_CPU_JSUB,
		!bFullScreen && jsub_available && jsub_enable);
	EnableMenuSub(hMenu, IDM_DISASM_JSUB,
		!bFullScreen && jsub_available && jsub_enable);
	EnableMenuSub(hMenu, IDM_MEMORY_JSUB,
		!bFullScreen && jsub_available && jsub_enable);
#endif
#ifdef Z80CARD
	EnableMenuSub(hMenu, IDM_CPU_MAINZ80, !bFullScreen);
	EnableMenuSub(hMenu, IDM_DISASM_MAINZ80, !bFullScreen);
#endif
#endif
}

/*-[ c[j[ ]-------------------------------------------------------*/

/*
 *	}EX[h؂芷
 */
#ifdef MOUSE
void FASTCALL MouseModeChange(BOOL flag)
{
	/* [hωȂ΋A */
	if (mos_capture == flag) {
		return;
	}

	/* }EXLv`tOݒ */
	mos_capture = flag;

	/* Xe[^Xo[ɏԕ\ */
	if (flag) {
		SetStatusMessage(IDS_MOUSE_ENABLE);
	}
	else {
		SetStatusMessage(IDS_MOUSE_DISABLE);
	}
}
#endif

/*
 *	AWXg
 */
#if XM7_VER >= 2
static void FASTCALL OnTimeAdjust(void)
{
	/* Đݒ肷 */
	rtc_time_adjust();

	/* Ô߃XPW[ */
	rtc_reset();
}
#endif

/*
 *	}EX[h؂芷(M)
 */
#ifdef MOUSE
static void FASTCALL OnMouseMode(void)
{
	/* }EXLv`tO𔽓]ă[h؂ւ */
	MouseModeChange(!mos_capture);
}
#endif

/*
 *	ʃLv`(C)
 */
static void FASTCALL OnGrpCapture(void)
{
	char path[_MAX_PATH];

	/* t@CI */
	if (!FileSelectSub(FALSE, IDS_GRPCAPFILTER, path, "BMP", BMP_FILE_DIR)) {
		return;
	}

	/* Lv` */
	LockVM();
	StopSnd();
#if XM7_VER <= 2
	capture_to_bmp(path, bFullScan, nMonitorType, bPseudo400Line);
#else
	capture_to_bmp(path, bFullScan, FALSE, bPseudo400Line);
#endif
	PlaySnd();
	ResetSch();
	UnlockVM();
}

/*
 *	ʃLv`2
 */
static void FASTCALL OnGrpCapture2(void)
{
	char path[_MAX_PATH];

	/* t@CI */
	if (!FileSelectSub(FALSE, IDS_GRPCAPFILTER, path, "BMP", BMP_FILE_DIR)) {
		return;
	}

	/* Lv` */
	LockVM();
	StopSnd();
#if XM7_VER <= 2
	capture_to_bmp2(path, nMonitorType, bPseudo400Line);
#else
	capture_to_bmp2(path, FALSE, bPseudo400Line);
#endif
	PlaySnd();
	ResetSch();
	UnlockVM();
}

/*
 *	WAVLv`(W)
 */
static void FASTCALL OnWavCapture(HWND hWnd)
{
	char path[_MAX_PATH];

	ASSERT(hWnd);

	/* ɃLv`ȂAN[Y */
	if (hWavCapture >= 0) {
		LockVM();
		CloseCaptureSnd();
		UnlockVM();
		return;
	}

	/* t@CI */
	if (!FileSelectSub(FALSE, IDS_WAVCAPFILTER, path, "WAV", WAV_FILE_DIR)) {
		return;
	}

	/* Lv` */
	LockVM();
	OpenCaptureSnd(path);
	UnlockVM();

	/*  */
	if (hWavCapture < 0) {
		LockVM();
		StopSnd();

		LoadString(hAppInstance, IDS_WAVCAPERROR, path, sizeof(path));
		MessageBox(hWnd, path, "XM7", MB_ICONSTOP | MB_OK);
		SetMenuExitTimer();

		PlaySnd();
		ResetSch();
		UnlockVM();
	}
}

/*
 *	VKfBXN쐬(D)
 */
static void FASTCALL OnNewDisk(HWND hWnd)
{
	char path[_MAX_PATH];
	int ret;
	char ext[_MAX_EXT];
	BOOL err;

	ASSERT(hWnd);

	/* ^Cg */
	ret = DialogBox(hAppInstance, MAKEINTRESOURCE(IDD_TITLEDLG),
						hWnd, TitleDlgProc);
	if (ret != IDOK) {
		return;
	}

	/* t@CI */
	if (!FileSelectSub(FALSE, IDS_NEWDISKFILTER, path, "D77", DISK_IMAGE_DIR))
	{
		return;
	}

	/* 쐬 */
	LockVM();
	StopSnd();

	/* gq */
	_splitpath(path, NULL, NULL, NULL, ext);

	if (DiskFormat) {
		if (stricmp(ext, ".FDX") == 0) {
			err = make_new_userdisk_fdx(path, DiskTitle, DiskMedia);
		} else {
			err = make_new_userdisk(path, DiskTitle, DiskMedia);
		}
	}
	else {
		if (stricmp(ext, ".FDX") == 0) {
			err = make_new_fdx(path, DiskTitle, DiskMedia);
		} else {
			err = make_new_d77(path, DiskTitle, DiskMedia);
		}
	}
	if (err) {
		LoadString(hAppInstance, IDS_NEWDISKOK, path, sizeof(path));
		MessageBox(hWnd, path, "XM7", MB_OK);
		SetMenuExitTimer();
	}

	PlaySnd();
	ResetSch();
	UnlockVM();
}

/*
 *	VKe[v쐬(T)
 */
static void FASTCALL OnNewTape(HWND hWnd)
{
	char path[_MAX_PATH];

	ASSERT(hWnd);

	/* t@CI */
	if (!FileSelectSub(FALSE, IDS_TAPEFILTER, path, "T77", TAPE_IMAGE_DIR)) {
		return;
	}

	/* 쐬 */
	LockVM();
	StopSnd();

	if (make_new_t77(path)) {
		LoadString(hAppInstance, IDS_NEWTAPEOK, path, sizeof(path));
		MessageBox(hWnd, path, "XM7", MB_OK);
		SetMenuExitTimer();
	}

	PlaySnd();
	ResetSch();
	UnlockVM();
}

#if XM7_VER == 1 && defined(BUBBLE)
/*
 *	VKouJZbg쐬(B)
 */
static void FASTCALL OnNewBubble(HWND hWnd)
{
	char path[_MAX_PATH];
	int ret;
	BOOL err;

	ASSERT(hWnd);

	/* ^Cg */
	strncpy(BubbleTitle, "Default", sizeof(BubbleTitle));
	ret = DialogBox(hAppInstance, MAKEINTRESOURCE(IDD_MEDIATYPEDLG),
						hWnd, BubbleMediaTypeDlgProc);
	if (ret != IDOK) {
		return;
	}

	/* t@CI */
	if (BubbleFormat) {
		if (!FileSelectSub(FALSE, IDS_B77FILTER, path, "B77",
			BUBBLE_IMAGE_DIR)) {
			return;
		}
	}
	else {
		if (!FileSelectSub(FALSE, IDS_BBLFILTER, path, "BBL",
			BUBBLE_IMAGE_DIR)) {
			return;
		}
	}

	/* 쐬 */
	LockVM();
	StopSnd();

	if (BubbleFormat) {
		err = make_new_bubble(path, BubbleTitle);
	}
	else {
		err = make_new_bubble(path, NULL);
	}
	if (err) {
		LoadString(hAppInstance, IDS_NEWBUBBLEOK, path, sizeof(path));
		MessageBox(hWnd, path, "XM7", MB_OK);
		SetMenuExitTimer();
	}

	PlaySnd();
	ResetSch();
	UnlockVM();
}
#endif

/*
 *	VFDD77ϊ(V)
 */
static void FASTCALL OnVFD2D77(HWND hWnd)
{
	char src[_MAX_PATH];
	char dst[_MAX_PATH];
	int ret;

	ASSERT(hWnd);

	/* t@CI */
	if (!FileSelectSub(TRUE, IDS_VFDFILTER, src, "VFD", DISK_IMAGE_DIR)) {
		return;
	}

	/* ^Cg */
	strncpy(DiskTitle, "Default", sizeof(DiskTitle));
	ret = DialogBox(hAppInstance, MAKEINTRESOURCE(IDD_TITLEDLG_2D),
						hWnd, TitleDlg2DProc);
	if (ret != IDOK) {
		SetMenuExitTimer();
		return;
	}

	/* t@CI */
	if (!FileSelectSub(FALSE, IDS_CNVDISKFILTER, dst, "D77", DISK_IMAGE_DIR)) {
		return;
	}

	/* 쐬 */
	LockVM();
	StopSnd();

	if (conv_vfd_to_d77(src, dst, DiskTitle)) {
		LoadString(hAppInstance, IDS_CONVERTOK, src, sizeof(src));
	}
	else {
		LoadString(hAppInstance, IDS_CONVERTFAIL, src, sizeof(src));
	}
	MessageBox(hWnd, src, "XM7", MB_OK);
	SetMenuExitTimer();

	PlaySnd();
	ResetSch();
	UnlockVM();
}

/*
 *	2DD77ϊ(2)
 */
static void FASTCALL On2D2D77(HWND hWnd)
{
	char src[_MAX_PATH];
	char dst[_MAX_PATH];
	int ret;

	ASSERT(hWnd);

	/* t@CI */
	if (!FileSelectSub(TRUE, IDS_2DFILTER, src, "2D", DISK_IMAGE_DIR)) {
		return;
	}

	/* ^Cg */
	strncpy(DiskTitle, "Default", sizeof(DiskTitle));
	ret = DialogBox(hAppInstance, MAKEINTRESOURCE(IDD_TITLEDLG_2D),
						hWnd, TitleDlg2DProc);
	if (ret != IDOK) {
		SetMenuExitTimer();
		return;
	}

	/* t@CI */
	if (!FileSelectSub(FALSE, IDS_CNVDISKFILTER, dst, "D77", DISK_IMAGE_DIR)) {
		return;
	}

	/* 쐬 */
	LockVM();
	StopSnd();

	if (conv_2d_to_d77(src, dst, DiskTitle)) {
		LoadString(hAppInstance, IDS_CONVERTOK, src, sizeof(src));
	}
	else {
		LoadString(hAppInstance, IDS_CONVERTFAIL, src, sizeof(src));
	}
	MessageBox(hWnd, src, "XM7", MB_OK);
	SetMenuExitTimer();

	PlaySnd();
	ResetSch();
	UnlockVM();
}

/*
 *	VTPT77ϊ(P)
 */
static void FASTCALL OnVTP2T77(HWND hWnd)
{
	char src[_MAX_PATH];
	char dst[_MAX_PATH];

	ASSERT(hWnd);

	/* t@CI */
	if (!FileSelectSub(TRUE, IDS_VTPFILTER, src, "VTP", TAPE_IMAGE_DIR)) {
		return;
	}

	/* t@CI */
	if (!FileSelectSub(FALSE, IDS_TAPEFILTER, dst, "T77", TAPE_IMAGE_DIR)) {
		return;
	}

	/* 쐬 */
	LockVM();
	StopSnd();

	if (conv_vtp_to_t77(src, dst)) {
		LoadString(hAppInstance, IDS_CONVERTOK, src, sizeof(src));
	}
	else {
		LoadString(hAppInstance, IDS_CONVERTFAIL, src, sizeof(src));
	}
	MessageBox(hWnd, src, "XM7", MB_OK);
	SetMenuExitTimer();

	PlaySnd();
	ResetSch();
	UnlockVM();
}

#if XM7_VER == 1 && defined(BUBBLE)
/*
 *	BBLB77ϊ(L)
 */
static void FASTCALL OnBBL2B77(HWND hWnd)
{
	char src[_MAX_PATH];
	char dst[_MAX_PATH];
	int ret;

	ASSERT(hWnd);

	/* t@CI */
	if (!FileSelectSub(TRUE, IDS_BBLFILTER, src, "BBL", BUBBLE_IMAGE_DIR)) {
		return;
	}

	/* ^Cg */
	strncpy(DiskTitle, "Default", sizeof(DiskTitle));
	ret = DialogBox(hAppInstance, MAKEINTRESOURCE(IDD_TITLEDLG_2D),
						hWnd, TitleDlg2DProc);
	if (ret != IDOK) {
		SetMenuExitTimer();
		return;
	}

	/* t@CI */
	if (!FileSelectSub(FALSE, IDS_B77FILTER, dst, "B77", BUBBLE_IMAGE_DIR)) {
		return;
	}

	/* 쐬 */
	LockVM();
	StopSnd();

	if (conv_bbl_to_b77(src, dst, DiskTitle)) {
		LoadString(hAppInstance, IDS_CONVERTOK, src, sizeof(src));
	}
	else {
		LoadString(hAppInstance, IDS_CONVERTFAIL, src, sizeof(src));
	}
	MessageBox(hWnd, src, "XM7", MB_OK);
	SetMenuExitTimer();

	PlaySnd();
	ResetSch();
	UnlockVM();
}
#endif

#ifdef KBDPASTE
/*
 *	\t(E)
 */
static void FASTCALL OnPaste(HWND hWnd)
{
	ASSERT(hWnd);

	/* y[Xg҂Ԑݒ肪Ȃꍇ */
	if ((uPasteWait == 0) && (uPasteWaitCntl == 0)) {
		return;
	}

	/* s */
	LockVM();
	StopSnd();

	PasteClipboardKbd(hWnd);

	PlaySnd();
	ResetSch();
	UnlockVM();
}

/*
 *	L[͎x(K)
 */
static void FASTCALL OnKeyStroke(HWND hWnd)
{
	int ret;

	ASSERT(hWnd);

	/* y[Xg҂Ԑݒ肪Ȃꍇ */
	if ((uPasteWait == 0) && (uPasteWaitCntl == 0)) {
		return;
	}

	/* s */
	if (bFullScreen || !bKeyStrokeModeless) {
		/* dɊJȂ */
		if (hKeyStrokeDialog) {
			/* EChEN[Y */
			PostMessage(hKeyStrokeDialog, WM_CLOSE, 0, 0);
			Sleep(1);
		}

		/* L[͎x_CAO */
		ret = DialogBox(hAppInstance, MAKEINTRESOURCE(IDD_KEYSTROKEDLG),
						hWnd, KeyStrokeDlgProc);
		if (ret != IDOK) {
			return;
		}

		/* 쐬 */
		LockVM();
		PasteKbd((char *)KeyStrokeString);
		InvalidateRect(hDrawWnd, NULL, FALSE);
		UnlockVM();
	}
	else {
		/* dɊJȂ */
		if (hKeyStrokeDialog) {
			SetForegroundWindow(hKeyStrokeDialog);
			return;
		}

		/* L[͎x_CAO */
		hKeyStrokeDialog = CreateDialog(
			(HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE),
			MAKEINTRESOURCE(IDD_KEYSTROKEDLG),
			hWnd,
			(DLGPROC)KeyStrokeDlgProc);
		if (hKeyStrokeDialog == NULL) {
			return;
		}
		ShowWindow(hKeyStrokeDialog, SW_SHOW);
		UpdateWindow(hKeyStrokeDialog);
	}
}
#endif

/*
 *	TEho̓[h؂ւ
 */
static void FASTCALL OnChgSound(void)
{
	LockVM();

	/* TEh[hύX */
	uStereoOut = (uStereoOut + 1) % 5;
	SetStatusMessage(IDS_SND_MONAURAL + uStereoOut);

	/* Kp */
	ApplySnd();
	UnlockVM();
}

/*
 *	TCNX`[[h؂ւ
 */
static void FASTCALL OnChgCycleSteal(void)
{
	LockVM();

	/* TCNX`[[hύX */
	cycle_steal = !cycle_steal;
	cycle_steal_default = cycle_steal;

	/* subclock_modecycle_steal̔] */
	subclock_mode = !cycle_steal;

	GetCfg();

	/* łsubclock_modeKv͂Ȃ */
	if (cycle_steal) {
		SetStatusMessage(IDS_ENABLE_CYCLESTEAL);
	}
	else {
		SetStatusMessage(IDS_DISABLE_CYCLESTEAL);
	}

	UnlockVM();
}

/*
 *	fBXN^CgύX
 */
static void FASTCALL OnSetDiskTitle(HWND hWnd, int Drive, int Index)
{
	char string[128];
	int ret, i;
	BOOL err;
	BYTE media;
	BOOL teject;

	ASSERT(hWnd);

	/* D77`FbN */
	if (fdc_ready[Drive] != FDC_TYPE_D77) {
		return;
	}

	/* ^Cg */
	strncpy(DiskTitle, fdc_name[Drive][Index], sizeof(DiskTitle));
	ret = DialogBox(hAppInstance, MAKEINTRESOURCE(IDD_TITLEDLG_2D),
					hWnd, TitleDlg2DProc);
	if (ret != IDOK) {
		SetMenuExitTimer();
		return;
	}

	/* 쐬 */
	LockVM();
	StopSnd();

	err = set_title_media(fdc_fname[Drive], Index, DiskTitle);
	if (err) {
		for (i = 0; i < FDC_DRIVES; i ++) {
			if (fdc_ready[i] == FDC_TYPE_NOTREADY) {
				continue;
			}
			media = fdc_media[i];
			teject = fdc_teject[i];
			fdc_setdisk(i, fdc_fname[i]);
			fdc_setmedia(i, media);
			fdc_teject[i] = teject;
		}
		LoadString(hAppInstance, IDS_SETTITLEOK, string, sizeof(string));
		MessageBox(hWnd, string, "XM7", MB_OK);
	}

	PlaySnd();
	ResetSch();
	UnlockVM();

	SetMenuExitTimer();
}

/*
 *	ouJZbg^CgύX
 */
#if XM7_VER == 1 && defined(BUBBLE)
static void FASTCALL OnSetBubbleTitle(HWND hWnd, int Unit, int Index)
{
	char string[128];
	int ret, i;
	BOOL err;
	BYTE media;
	BOOL teject;

	ASSERT(hWnd);

	/* `FbN */
	if (bmc_ready[Unit] != BMC_TYPE_B77) {
		return;
	}

	/* ^Cg */
	strncpy(DiskTitle, bmc_name[Unit][Index], sizeof(DiskTitle));
	ret = DialogBox(hAppInstance, MAKEINTRESOURCE(IDD_TITLEDLG_2D),
						hWnd, TitleDlg2DProc);
	if (ret != IDOK) {
		SetMenuExitTimer();
		return;
	}

	/* 쐬 */
	LockVM();
	StopSnd();

	err = set_title_media(bmc_fname[Unit], Index, DiskTitle);
	if (err) {
		for (i = 0; i < BMC_UNITS_32; i ++) {
			if (bmc_ready[i] == BMC_TYPE_NOTREADY) {
				continue;
			}
			media = bmc_media[i];
			teject = bmc_teject[i];
			bmc_setfile(i, bmc_fname[i]);
			bmc_setmedia(i, media);
			bmc_teject[i] = teject;
		}
		LoadString(hAppInstance, IDS_SETTITLEOK, string, sizeof(string));
		MessageBox(hWnd, string, "XM7", MB_OK);
	}

	PlaySnd();
	ResetSch();
	UnlockVM();

	SetMenuExitTimer();
}
#endif	/* XM7_VER == 1 && defined(SFDC) */

/*
 *	c[(T)j[
 */
static BOOL FASTCALL OnTool(HWND hWnd, WORD wID)
{
	ASSERT(hWnd);

	switch (wID) {
		/* ݒ */
		case IDM_CONFIG:
			OnConfig(hWnd);
			return TRUE;

#ifdef MOUSE
		/* }EX[h؂芷 */
		case IDM_MOUSEMODE:
			if (bDetectMouse) {
				OnMouseMode();
			}
			return TRUE;

		/* }EX[h؂芷(F11,j[\) */
		case IDM_MOUSEMODE2:
			if (!kbd_table[DIK_F11] && bDetectMouse) {
				OnMouseMode();
			}
			return TRUE;

		/* }EX[hL */
		case IDM_MOUSEON:
			if (bDetectMouse) {
				MouseModeChange(TRUE);
			}
			return TRUE;

		/* }EX[h */
		case IDM_MOUSEOFF:
			if (bDetectMouse) {
				MouseModeChange(FALSE);
			}
			return TRUE;
#endif

#if XM7_VER >= 2
		/* AWXg */
		case IDM_TIMEADJUST:
			OnTimeAdjust();
			return TRUE;
#endif

		/* ʃLv` */
		case IDM_GRPCAP:
			OnGrpCapture();
			return TRUE;

		/* ʃLv`2 */
		case IDM_GRPCAP2:
			OnGrpCapture2();
			return TRUE;

		/* WAVLv` */
		case IDM_WAVCAP:
			OnWavCapture(hWnd);
			return TRUE;

		/* VKfBXN */
		case IDM_NEWDISK:
			OnNewDisk(hWnd);
			return TRUE;

		/* VKe[v */
		case IDM_NEWTAPE:
			OnNewTape(hWnd);
			return TRUE;

#if XM7_VER == 1 && defined(BUBBLE)
		/* VKouJZbg */
		case IDM_NEWBUBBLE:
			OnNewBubble(hWnd);
			return TRUE;
#endif

		/* VFDD77 */
		case IDM_VFD2D77:
			OnVFD2D77(hWnd);
			return TRUE;

		/* 2DD77 */
		case IDM_2D2D77:
			On2D2D77(hWnd);
			return TRUE;

		/* VTPT77 */
		case IDM_VTP2T77:
			OnVTP2T77(hWnd);
			return TRUE;

#if XM7_VER == 1 && defined(BUBBLE)
		/* BBLB77 */
		case IDM_BBL2B77:
			OnBBL2B77(hWnd);
			return TRUE;
#endif

#ifdef KBDPASTE
		/* \t */
		case IDM_PASTE:
			OnPaste(hWnd);
			return TRUE;

		/* L[͎x */
		case IDM_KEYSTROKE:
			OnKeyStroke(hWnd);
			return TRUE;
#endif

		/* TEho͐؂ւ(j[\) */
		case IDM_CHG_SOUNDMODE:
			OnChgSound();
			return TRUE;

		/* TCNX`[[h؂ւ(j[\) */
		case IDM_CYCLESTEAL:
			OnChgCycleSteal();
			return TRUE;
	}

	return FALSE;
}

/*
 *	c[(T)j[XV
 */
static void FASTCALL OnToolPopup(HMENU hMenu)
{
#ifdef MOUSE
	MENUITEMINFO mii;
	char string[128];
#endif
#ifdef KBDPASTE
	UINT uitem;
#endif

	ASSERT(hMenu);

#ifdef MOUSE
	/* j[ڂ炢폜 */
	DeleteMenu(hMenu, IDM_MOUSEMODE, MF_BYCOMMAND);

	/* ߂čڂ˂ */
	if (kbd_table[DIK_F11]) {
		LoadString(hAppInstance, IDS_MOUSEMODE_DISF11, string, sizeof(string));
	}
	else {
		LoadString(hAppInstance, IDS_MOUSEMODE_ENBF11, string, sizeof(string));
	}

	memset(&mii, 0, sizeof(mii));
	mii.cbSize = 44;	/* sizeof(mii)WINVER>=0x0500 */
	mii.fMask = MIIM_TYPE | MIIM_STATE | MIIM_ID;
	mii.fType = MFT_STRING;
	mii.fState = MFS_ENABLED;
	mii.wID = IDM_MOUSEMODE;
	mii.dwTypeData = string;
	mii.cch = strlen(string);
#if XM7_VER >= 2
	InsertMenuItem(hMenu, IDM_TIMEADJUST, MF_BYCOMMAND, &mii);
#else
	InsertMenuItem(hMenu, 2, MF_BYPOSITION, &mii);
#endif
	EnableMenuItem(hMenu, IDM_MOUSEMODE, !bDetectMouse);

	/* }EX[h */
	CheckMenuSub(hMenu, IDM_MOUSEMODE, mos_capture);
#endif

	/* WAVLv` nhŃI[v */
	CheckMenuSub(hMenu, IDM_WAVCAP, (hWavCapture >= 0));

#ifdef KBDPASTE
	uitem = 12;
#ifdef MOUSE
	uitem += 1;
#endif
#if XM7_VER >= 2
	uitem += 1;
#endif
#if XM7_VER == 1 && defined(BUBBLE)
	uitem += 2;
#endif

	/* \t/L[͎x֘A̓j[ڂ폜 */
	while (GetMenuItemCount(hMenu) > (int)uitem) {
		DeleteMenu(hMenu, uitem, MF_BYPOSITION);
	}

	/* y[Xg҂Ԑݒ肪Ȃꍇ */
	if ((uPasteWait != 0) || (uPasteWaitCntl != 0)) {
		/* j[\̏ */
		memset(&mii, 0, sizeof(mii));
		mii.cbSize = 44;	/* sizeof(mii)WINVER>=0x0500 */

		/* Zp[^} */
		mii.fType = MFT_SEPARATOR;
		mii.fMask = MIIM_TYPE | MIIM_STATE | MIIM_ID;
		mii.fState = MFS_ENABLED;
		InsertMenuItem(hMenu, uitem++, TRUE, &mii);

		LoadString(hAppInstance, IDS_PASTE, string, sizeof(string));
		mii.fMask = MIIM_TYPE | MIIM_STATE | MIIM_ID;
		mii.fType = MFT_STRING;
		mii.fState = MFS_ENABLED;
		mii.wID = IDM_PASTE;
		mii.dwTypeData = string;
		mii.cch = strlen(string);
		InsertMenuItem(hMenu, uitem++, TRUE, &mii);

		LoadString(hAppInstance, IDS_KEYSTROKE, string, sizeof(string));
		mii.fMask = MIIM_TYPE | MIIM_STATE | MIIM_ID;
		mii.fType = MFT_STRING;
		mii.fState = MFS_ENABLED;
		mii.wID = IDM_KEYSTROKE;
		mii.dwTypeData = string;
		mii.cch = strlen(string);
		InsertMenuItem(hMenu, uitem++, TRUE, &mii);
	}
#endif
}

/*-[ EBhEj[ ]---------------------------------------------------*/

/*
 *	SEChE̕\ԂꊇĕύX
 */
static void FASTCALL ShowAllWindowSub(int CmdShow)
{
	int i;

	for (i=0; i<SWND_MAXNUM; i++) {
		if (hSubWnd[i]) {
			ShowWindow(hSubWnd[i], CmdShow);
		}
	}
}

/*
 *	d˂ĕ\(C)
 */
static void FASTCALL OnCascade(void)
{
	/* d˂ĕ\ */
	ASSERT(hDrawWnd);
	CascadeWindows(hDrawWnd, 0, NULL, 0, NULL);
}

/*
 *	ׂĕ\(T)
 */
static void FASTCALL OnTile(void)
{
	/* ׂĕ\ */
	ASSERT(hDrawWnd);
	TileWindows(hDrawWnd, MDITILE_VERTICAL, NULL, 0, NULL);
}

/*
 *	SăACR(I)
 */
static void FASTCALL OnIconic(void)
{
	ShowAllWindowSub(SW_MINIMIZE);
}

/*
 *	ACR̐(A)
 */
static void FASTCALL OnArrangeIcon(void)
{
	/* ACR̐ */
	ASSERT(hDrawWnd);
	ArrangeIconicWindows(hDrawWnd);
}

/*
 *	SĉB(H)
 */
static void FASTCALL OnHide(void)
{
	ShowAllWindowSub(SW_HIDE);
}

/*
 *	Sĕ(R)
 */
static void FASTCALL OnRestore(void)
{
	ShowAllWindowSub(SW_RESTORE);

	if (bPopupSwnd) {
		SetForegroundWindow(hMainWnd);
	}
}

/*
 *	Sĕ(O)
 */
static void FASTCALL OnClose(void)
{
	int i;

	for (i=0; i<SWND_MAXNUM; i++) {
		if (hSubWnd[i]) {
			DestroyWindow(hSubWnd[i]);
			hSubWnd[i] = NULL;
		}
	}
}

/*
 *	EBhE(W)j[
 */
static BOOL FASTCALL OnWindow(WORD wID)
{
	int i;

	switch (wID) {
		/* d˂ĕ\ */
		case IDM_CASCADE:
			OnCascade();
			return TRUE;

		/* ׂĕ\ */
		case IDM_TILE:
			OnTile();
			return TRUE;

		/* SăACR */
		case IDM_ICONIC:
			OnIconic();
			return TRUE;

		/* ACR̐ */
		case IDM_ARRANGEICON:
			OnArrangeIcon();
			return TRUE;

		/* SĉB */
		case IDM_ALLHIDE:
			OnHide();
			return TRUE;

		/* Sĕ */
		case IDM_ALLRESTORE:
			OnRestore();
			return TRUE;

		/* Sĕ */
		case IDM_ALLCLOSE:
			OnClose();
			return TRUE;
	}

	/* EBhEI */
	if ((wID >= IDM_SWND00) && (wID <= IDM_SWND15)) {
		for (i=0; i<SWND_MAXNUM; i++) {
			if (hSubWnd[i] == NULL) {
				continue;
			}

			/* JEg_EAOK */
			if (wID == IDM_SWND00) {
				ShowWindow(hSubWnd[i], SW_RESTORE);
				SetWindowPos(hSubWnd[i], HWND_TOP, 0, 0, 0, 0,
					SWP_NOMOVE | SWP_NOSIZE);
				break;
			}
			else {
				wID--;
			}
		}
	}

	return FALSE;
}

/*
 *	EBhE(W)j[XV
 */
static void FASTCALL OnWindowPopup(HMENU hMenu)
{
	int i;
	BOOL flag;
	MENUITEMINFO mii;
	UINT nID;
	int count;
	char string[128];

	ASSERT(hMenu);

	/* tXN[̐擪̂V̖ */
	EnableMenuSub(hMenu, IDM_CASCADE, !bFullScreen && !bPopupSwnd);
	EnableMenuSub(hMenu, IDM_TILE, !bFullScreen && !bPopupSwnd);
	EnableMenuSub(hMenu, IDM_ICONIC, !bFullScreen);
	EnableMenuSub(hMenu, IDM_ARRANGEICON, !bFullScreen && !bPopupSwnd);
	EnableMenuSub(hMenu, IDM_ALLHIDE, !bFullScreen);
	EnableMenuSub(hMenu, IDM_ALLRESTORE, !bFullScreen);
	EnableMenuSub(hMenu, IDM_ALLCLOSE, !bFullScreen);

	/* 擪̂Vcč폜 */
	while (GetMenuItemCount(hMenu) > 7) {
		DeleteMenu(hMenu, 7, MF_BYPOSITION);
	}

	/* LȃTuEChEȂ΁Â܂܃^[ */
	flag = FALSE;
	for (i=0; i<SWND_MAXNUM; i++) {
		if (hSubWnd[i] != NULL) {
			flag = TRUE;
		}
	}
	if (!flag) {
		return;
	}

	/* j[\̏ */
	memset(&mii, 0, sizeof(mii));
	mii.cbSize = 44;	/* sizeof(mii)WINVER>=0x0500 */
	mii.fMask = MIIM_TYPE | MIIM_STATE | MIIM_ID;
	mii.fType = MFT_STRING;
	mii.fState = MFS_ENABLED;

	/* Zp[^} */
	mii.fType = MFT_SEPARATOR;
	InsertMenuItem(hMenu, 7, TRUE, &mii);
	mii.fType = MFT_STRING;

	/* EChE^CgZbg */
	count = 0;
	nID = IDM_SWND00;
	for (i=0; i<SWND_MAXNUM; i++) {
		if (hSubWnd[i] != NULL) {
			/* j[} */
			mii.wID = nID;
			memset(string, 0, sizeof(string));
			GetWindowText(hSubWnd[i], string, sizeof(string) - 1);
			mii.dwTypeData = string;
			mii.cch = strlen(string);
			InsertMenuItem(hMenu, count + 8, TRUE, &mii);
			EnableMenuSub(hMenu, nID, !bFullScreen);

			/*  */
			nID++;
			count++;
		}
	}
}

/*-[ wvj[ ]-------------------------------------------------------*/

/*
 *	wv(H)j[
 */
static BOOL FASTCALL OnHelp(HWND hWnd, WORD wID)
{
	switch (wID) {
		/* o[W */
		case IDM_ABOUT:
			OnAbout(hWnd);
			return TRUE;
	}

	return FALSE;
}

/*-[ ReLXgj[ ]-------------------------------------------------*/

/*
 *	fBA^CgύX(&T)
 */
static BOOL FASTCALL OnMediaChangeTitle(HWND hWnd, WORD wID)
{
	ASSERT(hWnd);

	if ((wID >= IDM_D0MEDIA00) && (wID <= IDM_D0MEDIA15)) {
		OnSetDiskTitle(hWnd, 0, wID - IDM_D0MEDIA00);
		return TRUE;
	}
	if ((wID >= IDM_D1MEDIA00) && (wID <= IDM_D1MEDIA15)) {
		OnSetDiskTitle(hWnd, 1, wID - IDM_D1MEDIA00);
		return TRUE;
	}
#if XM7_VER == 1 && defined(BUBBLE)
	if ((wID >= IDM_B0MEDIA00) && (wID <= IDM_B0MEDIA15)) {
		OnSetBubbleTitle(hWnd, 0, wID - IDM_B0MEDIA00);
		return TRUE;
	}
	if ((wID >= IDM_B1MEDIA00) && (wID <= IDM_B1MEDIA15)) {
		OnSetBubbleTitle(hWnd, 1, wID - IDM_B1MEDIA00);
		return TRUE;
	}
#endif	/* XM7_VER == 1 && defined(BUBBLE) */

	return FALSE;
}

/*
 *	qXg폜(&D)
 */
static BOOL FASTCALL OnHistoryDelete(HWND hWnd, WORD wID)
{
	/* qXgENbNj[ */
	if ((wID >= IDM_STATE_FILE0) && (wID <= IDM_STATE_FILE9)) {
		DeleteHistory(hWnd, wID);
		return TRUE;
	}
	if ((wID >= IDM_D1_FILE0) && (wID <= IDM_D0_FILE9)) {
		DeleteHistory(hWnd, wID);
		return TRUE;
	}
	if ((wID >= IDM_T_FILE0) && (wID <= IDM_T_FILE9)) {
		DeleteHistory(hWnd, wID);
		return TRUE;
	}
#if XM7_VER == 1 && defined(BUBBLE)
	if ((wID >= IDM_B1_FILE0) && (wID <= IDM_B0_FILE9)) {
		DeleteHistory(hWnd, wID);
		return TRUE;
	}
#endif	/* XM7_VER == 1 && defined(BUBBLE) */

	return FALSE;
}

/*
 *	ReLXgj[̌Ăяo
 */
static BOOL FASTCALL OnSubMenu(HWND hWnd, WORD wID)
{
	switch (wID) {
		/* fBA^CgύX(&T) */
		case IDM_MEDIATITLE:
			OnMediaChangeTitle(hWnd, wMenuID);
			return TRUE;

		/* qXg폜(&D) */
		case IDM_HISTORY_DELETE:
			OnHistoryDelete(hWnd, wMenuID);
			return TRUE;
	}

	return FALSE;
}

/*-[ j[R}h ]-------------------------------------------------*/

/*
 *	j[R}h
 */
void FASTCALL OnCommand(HWND hWnd, WORD wID)
{
	ASSERT(hWnd);

	if (OnFile(hWnd, wID)) {
		return;
	}
	if (OnDisk(wID)) {
		return;
	}
	if (OnTape(wID)) {
		return;
	}
	if (OnView(hWnd, wID)) {
		return;
	}
	if (OnDebug(hWnd, wID)) {
		return;
	}
	if (OnTool(hWnd, wID)) {
		return;
	}
	if (OnWindow(wID)) {
		return;
	}
	if (OnHelp(hWnd, wID)) {
		return;
	}
	if (OnSubMenu(hWnd, wID)) {
		return;
	}
}

/*
 *	j[R}hXV
 */
void FASTCALL OnMenuPopup(HWND hWnd, HMENU hSubMenu, UINT uPos)
{
	HMENU hMenu;

	ASSERT(hWnd);
	ASSERT(hSubMenu);

	/* Cj[̍XV`FbN */
	hMenu = GetMenu(hWnd);
	if (GetSubMenu(hMenu, uPos) != hSubMenu) {
		return;
	}

	/* bNKv */
	LockVM();

	switch (uPos) {
		/* t@C */
		case 0:
			OnFilePopup(hSubMenu);
			break;

		/* hCu1 */
		case 1:
			OnDiskPopup(hSubMenu, 1);
			break;

		/* hCu0 */
		case 2:
			OnDiskPopup(hSubMenu, 0);
			break;

		/* e[v */
		case 3:
			OnTapePopup(hSubMenu);
			break;

		/* \ */
		case 4:
			OnViewPopup(hSubMenu);
			break;

		/* fobO */
		case 5:
			OnDebugPopup(hSubMenu);
			break;

		/* c[ */
		case 6:
			OnToolPopup(hSubMenu);
			break;

		/* EBhE */
		case 7:
			OnWindowPopup(hSubMenu);
			break;
	}

	/* AbN */
	UnlockVM();
}


/*
 *	ReLXgj[
 */
void FASTCALL OnContextualMenu(HWND hWnd, WORD wID, int x, int y)
{
	ASSERT(hWnd);

	if (OnFileContextualMenu(hWnd, wID, x, y)) {
		return;
	}
	if (OnDiskContextualMenu(hWnd, wID, x, y)) {
		return;
	}
	if (OnTapeContextualMenu(hWnd, wID, x, y)) {
		return;
	}
}

/*-[ hbOhbvER}hC ]-------------------------------*/

/*
 *	t@ChbvTu
 */
void FASTCALL OnDropSub(char *path)
{
	char dir[_MAX_DIR];
	char ext[_MAX_EXT];
	char InitDir[_MAX_DRIVE + _MAX_PATH];

	ASSERT(path);

	/* gq */
	_splitpath(path, InitDir, dir, NULL, ext);
	strncat(InitDir, dir, sizeof(InitDir) - strlen(InitDir) - 1);

	/* D77 */
	if (stricmp(ext, ".D77") == 0) {
		strncpy(InitialDir[DISK_IMAGE_DIR], InitDir,
			sizeof(InitialDir[DISK_IMAGE_DIR]));
		LockVM();
		StopSnd();
		fdc_setdisk(0, path);
		fdc_setdisk(1, NULL);
		if ((fdc_ready[0] != FDC_TYPE_NOTREADY) && (fdc_medias[0] >= 2)) {
			fdc_setdisk(1, path);
			fdc_setmedia(1, 1);
		}
		system_reset();
		OnRefresh(hMainWnd);
		PlaySnd();
		ResetSch();
		UnlockVM();
	}

	/* 2D/2DD/VFD/FDX */
#if XM7_VER >= 3
	if ((stricmp(ext, ".2D") == 0) || (stricmp(ext, ".2DD") == 0) ||
		(stricmp(ext, ".VFD") == 0) || (stricmp(ext, ".FDX") == 0)) {
#else
	if ((stricmp(ext, ".2D") == 0) || (stricmp(ext, ".VFD") == 0) ||
		(stricmp(ext, ".FDX") == 0)) {
#endif
		strncpy(InitialDir[DISK_IMAGE_DIR], InitDir,
			sizeof(InitialDir[DISK_IMAGE_DIR]));
		LockVM();
		StopSnd();
		fdc_setdisk(0, path);
		fdc_setdisk(1, NULL);
		system_reset();
		OnRefresh(hMainWnd);
		PlaySnd();
		ResetSch();
		UnlockVM();
	}

	/* T77 */
	if (stricmp(ext, ".T77") == 0) {
		strncpy(InitialDir[TAPE_IMAGE_DIR], InitDir,
			sizeof(InitialDir[TAPE_IMAGE_DIR]));
		LockVM();
		tape_setfile(path);
		UnlockVM();
	}

#if XM7_VER == 1 && defined(BUBBLE)
	if (bmc_enable) {
		/* B77 */
		if (stricmp(ext, ".B77") == 0) {
			strncpy(InitialDir[BUBBLE_IMAGE_DIR], InitDir,
				sizeof(InitialDir[BUBBLE_IMAGE_DIR]));
			LockVM();
			StopSnd();
			if (bmc_enable) {
				bmc_setfile(0, path);
				bmc_setfile(1, NULL);
				if (bmc_ready[0] != BMC_TYPE_NOTREADY) {
					if (bmc_medias[0] >= 2) {
						bmc_setfile(1, path);
						bmc_setmedia(1, 1);
					}
				}
			}
			PlaySnd();
			ResetSch();
			UnlockVM();
		}
	}

	/* BBL */
	if (stricmp(ext, ".BBL") == 0) {
		strncpy(InitialDir[BUBBLE_IMAGE_DIR], InitDir,
			sizeof(InitialDir[BUBBLE_IMAGE_DIR]));
		LockVM();
		bmc_setfile(0, path);
		bmc_setfile(1, NULL);
		UnlockVM();
	}
#endif

	/* XM7 */
	if (stricmp(ext, ".XM7") == 0) {
		strncpy(InitialDir[STATE_FILE_DIR], InitDir,
			sizeof(InitialDir[STATE_FILE_DIR]));
		LockVM();
		StopSnd();
		StateLoad(path);
		GetCfg();
		PlaySnd();
		ResetSch();
		UnlockVM();
	}

	/* \eXV */
	if (hDrawWnd) {
		InvalidateRect(hDrawWnd, NULL, FALSE);
	}
}

/*
 *	Xe[^Xo[
 *	t@ChbvTu
 */
void FASTCALL OnBarDropSub(char *path, POINT point)
{
	char dir[_MAX_DIR];
	char ext[_MAX_EXT];
	char InitDir[_MAX_DRIVE + _MAX_PATH];
	int drive;

	ASSERT(path);

	/* gq */
	_splitpath(path, InitDir, dir, NULL, ext);
	strncat(InitDir, dir, sizeof(InitDir) - strlen(InitDir) - 1);

	/* fBXNC[W */
	if ((point.x >= uPaneX[0]) && (point.x < uPaneX[2])) {
		/* hCu */
		if (point.x >= uPaneX[1]) {
			drive = 0;
		}
		else {
			drive = 1;
		}

		/* D77 */
		if (stricmp(ext, ".D77") == 0) {
			strncpy(InitialDir[DISK_IMAGE_DIR], InitDir,
				sizeof(InitialDir[DISK_IMAGE_DIR]));
			LockVM();
			StopSnd();
			fdc_setdisk(drive, path);
			PlaySnd();
			ResetSch();
			UnlockVM();
			return;
		}

		/* 2D/2DD/VFD */
#if XM7_VER >= 3
		if ((stricmp(ext, ".2D") == 0) || (stricmp(ext, ".2DD") == 0) ||
			(stricmp(ext, ".VFD") == 0)) {
#else
		if ((stricmp(ext, ".2D") == 0) || (stricmp(ext, ".VFD") == 0)) {
#endif
			strncpy(InitialDir[DISK_IMAGE_DIR], InitDir,
				sizeof(InitialDir[DISK_IMAGE_DIR]));
			LockVM();
			StopSnd();
			fdc_setdisk(drive, path);
			PlaySnd();
			ResetSch();
			UnlockVM();
			return;
		}
	}

	/* fBXNC[WȊOE͈͊O */
	OnDropSub(path);
}

/*
 *	t@Chbv
 */
void FASTCALL OnDropFiles(HANDLE hDrop)
{
	char path[_MAX_PATH];
	POINT point;
	POINT spoint;
	HWND hwnd;

	ASSERT(hDrop);

	/* t@C󂯎 */
	DragQueryPoint(hDrop, &point);
	DragQueryFile(hDrop, 0, path, sizeof(path));
	DragFinish(hDrop);

	/*  */
	spoint = point;
	ClientToScreen(hMainWnd, &spoint);
	hwnd = WindowFromPoint(spoint);
	if (hwnd == hStatusBar) {
		/* Xe[^Xo[ւ̃hbv */
		OnBarDropSub(path, point);
	}
	else {
		/* h[EBhEւ̃hbv͏] */
		OnDropSub(path);
	}
}

/*
 *	R}hC
 */
void FASTCALL OnCmdLine(LPSTR lpCmdLine)
{
	char dir[_MAX_DIR];
	char ext[_MAX_EXT];
	char path[_MAX_PATH];
	char fullpath[_MAX_PATH];
	char d77_path[_MAX_PATH];
	char InitDir[_MAX_PATH];
	LPSTR p;
	LPSTR q;
	BOOL flag;
	int drive;
#if XM7_VER == 1 && defined(BUBBLE)
	int unit;
	char bbl_path[_MAX_PATH];
#endif
	BOOL tape_set;

	ASSERT(lpCmdLine);

	/* [N */
	drive = 0;
#if XM7_VER == 1 && defined(BUBBLE)
	unit = 0;
#endif
	tape_set = FALSE;
	d77_path[0] = '\0';

	/* t@CXLbv */
	p = lpCmdLine;
	flag = FALSE;
	for (;;) {
		/* I`FbN */
		if (*p == '\0') {
			return;
		}

		/* NH[g`FbN */
		if (*p == '"') {
			flag = !flag;
		}

		/* Xy[X`FbN */
		if ((*p == ' ') && !flag) {
			break;
		}

		/*  */
		p++;
	}

	/* VMbN */
	LockVM();
	StopSnd();

	/* R}hCIvVI܂Ń[v */
	while (*p) {
		path[0] = '\0';

		/* Xy[Xǂݔ΂ */
		for (;;) {
			if (*p != ' ') {
				break;
			}

			/*  */
			p++;
		}

		if (*p == '"') {
			/* NH[g`FbN */
			p++;
			q = path;

			/* NH[go܂ő */
			for (;;) {
				*q = *p++;

				/* NH[gI`FbN */
				if (*q == '\0') {
					path[0] = '\0';
					break;
				}

				/* NH[g`FbN */
				if (*q == '"') {
					*q = '\0';
					break;
				}

				/*  */
				q++;
			}
		}
		else if (*p) {
			/* NH[gȂ */
			q = path;

			/* Xy[Xo邩񂪏I܂ő */
			for (;;) {
				*q = *p++;

				/* ؂蕶`FbN */
				if ((*q == '\0') || (*q == ' ')) {
					*q = '\0';
					break;
				}

				/*  */
				q++;
			}
		}

		/* I`FbN */
		if (!path[0]) {
			break;
		}

		/* tpX𐶐 */
		_fullpath(fullpath, path, _MAX_PATH);

		/* gq */
		_splitpath(fullpath, InitDir, dir, NULL, ext);
		strncat(InitDir, dir, sizeof(InitDir) - strlen(InitDir) - 1);

		/* D77/2D/2DD/VFD */
#if XM7_VER >= 3
		if ((stricmp(ext, ".D77") == 0) || (stricmp(ext, ".VFD") == 0) ||
			(stricmp(ext, ".2D") == 0) || (stricmp(ext, ".2DD") == 0)) {
#else
		if ((stricmp(ext, ".D77") == 0) || (stricmp(ext, ".VFD") == 0) ||
			(stricmp(ext, ".2D") == 0)) {
#endif

			/* 2܂Ń}Eg\ */
			if (drive < 2) {
				if (drive == 0) {
					/* 1ڂ̏ꍇApXۑ */
					strncpy(InitialDir[DISK_IMAGE_DIR], InitDir,
						sizeof(InitialDir[DISK_IMAGE_DIR]));

					/* D771w肵ꍇ̂߂Ƀt@Cۑ */
					if (stricmp(ext, ".D77") == 0) {
						strncpy(d77_path, fullpath, sizeof(d77_path));
					}
				}

				/* fBXN}Eg */
				fdc_setdisk(drive, fullpath);

				/* }EgȂhCuԍ(=}Eg)+1 */
				if (fdc_ready[drive] != FDC_TYPE_NOTREADY) {
					drive ++;
				}
			}
		}

		/* T77 */
		if (stricmp(ext, ".T77") == 0) {
			/* LȂ̂1̂ */
			if (!tape_set) {
				/* pXۑ */
				strncpy(InitialDir[TAPE_IMAGE_DIR], InitDir,
					sizeof(InitialDir[TAPE_IMAGE_DIR]));

				/* e[v}Eg */
				tape_setfile(fullpath);

				/* }EgȂe[v}Eg֎~tO𗧂Ă */
				if (tape_fileh != -1) {
					tape_set = TRUE;
				}
			}
		}

#if XM7_VER == 1 && defined(BUBBLE)
		/* B77/BBL */
		if (((stricmp(ext, ".B77") == 0) || (stricmp(ext, ".BBL") == 0)) &&
			bmc_enable) {

			if (unit == 0) {
				/* 1ڂ̏ꍇApXۑ */
				strncpy(InitialDir[BUBBLE_IMAGE_DIR], InitDir,
					sizeof(InitialDir[BUBBLE_IMAGE_DIR]));

				/* BBL1w肵ꍇ̂߂Ƀt@Cۑ */
				if (stricmp(ext, ".BBL") == 0) {
					strncpy(bbl_path, fullpath, sizeof(bbl_path));
				}

				/* jbg1̃}Eg */
				bmc_setfile(0, NULL);
				bmc_setfile(1, NULL);
			}

			/* 2܂Ń}Eg\ */
			if (unit < 2 && bmc_enable) {
				/* ouJZbg}Eg */
				bmc_setfile(unit, path);

				/* }EgȂ烆jbgԍ(=}Eg)+1 */
				if (bmc_ready[unit] != BMC_TYPE_NOTREADY) {
					unit ++;
				}
			}
		}
#endif

		/* XM7 */
		if (stricmp(ext, ".XM7") == 0) {
			strncpy(InitialDir[STATE_FILE_DIR], InitDir,
				sizeof(InitialDir[STATE_FILE_DIR]));
			StateLoad(fullpath);
			GetCfg();

			/* Xe[g[hɃ}Egŝŏł؂ */
			drive = 0;
#if XM7_VER == 1 && defined(BUBBLE)
			unit = 0;
#endif
			break;
		}
	}

	/* fBXNC[Wt@Cw萔1̏ꍇ̓ꏈ */
	if (drive == 1) {
		/* hCu1̃}Eg */
		fdc_setdisk(1, NULL);

		/* D77̏ꍇA2ڂ΃hCu1Ƀ}Eg */
		if (d77_path[0]) {
			if ((fdc_ready[0] != FDC_TYPE_NOTREADY) && (fdc_medias[0] >= 2)) {
				fdc_setdisk(1, d77_path);
				fdc_setmedia(1, 1);
			}
		}
	}

#if XM7_VER == 1 && defined(BUBBLE)
	/* ouC[Wt@Cw萔1̏ꍇ̓ꏈ */
	if (unit == 1) {
		/* B77̏ꍇA2ڂ΃hCu1Ƀ}Eg */
		if (bbl_path[0]) {
			if ((bmc_ready[0] != BMC_TYPE_NOTREADY) && (bmc_medias[0] >= 2)) {
				bmc_setfile(1, bbl_path);
				bmc_setmedia(1, 1);
			}
		}
	}
#endif

	/* fBXNC[W}EgꂽꍇAVMZbg */
	if (drive >= 1) {
		system_reset();
		OnRefresh(hMainWnd);
	}

	/* VMAbN */
	PlaySnd();
	ResetSch();
	UnlockVM();

	/* \eXV */
	if (hDrawWnd) {
		InvalidateRect(hDrawWnd, NULL, FALSE);
	}
}

#endif	/* _WIN32 */
